/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TextureStringCache {
    private static final int MAX_CACHE_SIZE = 512;
    private static final Map<String, String> CACHE = new LinkedHashMap<String, String>(513, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 512;
        }
    };
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOrCache(String textureId) {
        String cached;
        if (textureId == null) {
            return null;
        }
        LOCK.readLock().lock();
        try {
            cached = CACHE.get(textureId);
            if (cached != null) {
                String string = cached;
                return string;
            }
        }
        finally {
            LOCK.readLock().unlock();
        }
        LOCK.writeLock().lock();
        try {
            cached = CACHE.get(textureId);
            if (cached != null) {
                String string = cached;
                return string;
            }
            String interned = textureId.intern();
            CACHE.put(textureId, interned);
            String string = interned;
            return string;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static void clear() {
        LOCK.writeLock().lock();
        try {
            CACHE.clear();
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static int size() {
        LOCK.readLock().lock();
        try {
            int n = CACHE.size();
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }
}

