/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.blocks;

import io.github.leonard1504.config.FetzisAsianDecoConfig;
import io.github.leonard1504.entity.custom.GongBlockEntity;
import io.github.leonard1504.init.blockEntityInit;
import io.github.leonard1504.init.soundsInit;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3867;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class Gong
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2754<class_3867> ATTACHMENT = class_2754.method_11850((String)"attachment", class_3867.class);
    public final class_265 NORTH_SOUTH = class_259.method_1081((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    public final class_265 WEST_EAST = class_259.method_1081((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);
    public static class_265 SHAPE = class_259.method_1073();

    public Gong(class_4970.class_2251 properties) {
        super(properties);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GongBlockEntity(pos, state);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.getShapeForAttachment(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.getShapeForAttachment(state);
    }

    private class_265 getShapeForAttachment(class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_3867 attachment = (class_3867)state.method_11654(ATTACHMENT);
        if (attachment == class_3867.field_17100 || attachment == class_3867.field_17101) {
            if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
                return this.NORTH_SOUTH;
            }
            if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
                return this.WEST_EAST;
            }
        }
        if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
            return this.NORTH_SOUTH;
        }
        if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
            return this.WEST_EAST;
        }
        return class_259.method_1073();
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity;
        if (!level.field_9236 && (blockEntity = level.method_8321(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            if (this.validSide(state, hit)) {
                gongBlockEntity.startRinging(hit.method_17780());
                this.playRandomGongSound(level, pos);
                this.attractMobs(level, pos);
            }
        }
        return class_1269.field_5812;
    }

    private boolean validSide(class_2680 state, class_3965 hit) {
        return state.method_11654(ATTACHMENT) == class_3867.field_17098 || state.method_11654(ATTACHMENT) == class_3867.field_17099 ? hit.method_17780() == state.method_11654((class_2769)FACING) || hit.method_17780() == ((class_2350)state.method_11654((class_2769)FACING)).method_10153() : hit.method_17780() != state.method_11654((class_2769)FACING) || hit.method_17780() != ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 pos;
        class_2586 blockEntity;
        if (!level.field_9236 && (blockEntity = level.method_8321(pos = hit.method_17777())) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            class_2350 hitDirection = hit.method_17780();
            gongBlockEntity.startRinging(hitDirection);
            this.playRandomGongSound(level, pos);
            this.attractMobs(level, pos);
        }
    }

    private void playRandomGongSound(class_1937 level, class_2338 pos) {
        if (level.field_9229.method_43056()) {
            level.method_8396(null, pos, (class_3414)soundsInit.GONG_1.get(), class_3419.field_15245, 1.0f, this.getRandomPitch(level));
        } else {
            level.method_8396(null, pos, (class_3414)soundsInit.GONG_2.get(), class_3419.field_15245, 1.0f, this.getRandomPitch(level));
        }
    }

    private float getRandomPitch(class_1937 level) {
        return 0.7f + level.field_9229.method_43057() * 0.3f;
    }

    private void attractMobs(class_1937 level, class_2338 gongPos) {
        int radius = FetzisAsianDecoConfig.getGongAttractRange();
        List mobs = level.method_8390(class_1309.class, new class_238(gongPos).method_1014((double)radius), mob -> mob.method_5864() == class_1299.field_6077);
        for (class_1309 mob2 : mobs) {
            if (!(mob2 instanceof class_1314)) continue;
            class_1314 pathfindingMob = (class_1314)mob2;
            pathfindingMob.method_5942().method_6337((double)gongPos.method_10263() + 0.5, (double)gongPos.method_10264() + 0.5, (double)gongPos.method_10260() + 0.5, 1.0);
        }
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        GongBlockEntity gongBlockEntity;
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof GongBlockEntity && (gongBlockEntity = (GongBlockEntity)blockEntity).isRinging()) {
            return (int)Math.ceil((1.0 - (double)gongBlockEntity.getRingingTicks() / 100.0) * 15.0);
        }
        return 0;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean isMoving) {
        class_2586 blockEntity;
        boolean powered;
        if (!level.field_9236 && (powered = level.method_49803(pos)) && (blockEntity = level.method_8321(pos)) instanceof GongBlockEntity) {
            GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
            gongBlockEntity.startRinging(class_2350.field_11043);
            this.playRandomGongSound(level, pos);
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ATTACHMENT});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8038();
        class_2338 blockPos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2350.class_2351 axis = direction.method_10166();
        if (axis == class_2350.class_2351.field_11052) {
            class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657(ATTACHMENT, (Comparable)(direction == class_2350.field_11033 ? class_3867.field_17099 : class_3867.field_17098))).method_11657((class_2769)FACING, (Comparable)context.method_8042());
            if (blockState.method_26184((class_4538)context.method_8045(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == class_2350.class_2351.field_11048 && level.method_8320(blockPos.method_10067()).method_26206((class_1922)level, blockPos.method_10067(), class_2350.field_11034) && level.method_8320(blockPos.method_10078()).method_26206((class_1922)level, blockPos.method_10078(), class_2350.field_11039) || axis == class_2350.class_2351.field_11051 && level.method_8320(blockPos.method_10095()).method_26206((class_1922)level, blockPos.method_10095(), class_2350.field_11035) && level.method_8320(blockPos.method_10072()).method_26206((class_1922)level, blockPos.method_10072(), class_2350.field_11043);
            class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction.method_10153())).method_11657(ATTACHMENT, (Comparable)(bl ? class_3867.field_17101 : class_3867.field_17100));
            if (blockState.method_26184((class_4538)context.method_8045(), context.method_8037())) {
                return blockState;
            }
            boolean bl2 = level.method_8320(blockPos.method_10074()).method_26206((class_1922)level, blockPos.method_10074(), class_2350.field_11036);
            if ((blockState = (class_2680)blockState.method_11657(ATTACHMENT, (Comparable)(bl2 ? class_3867.field_17098 : class_3867.field_17099))).method_26184((class_4538)context.method_8045(), context.method_8037())) {
                return blockState;
            }
        }
        return null;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_3867 bellAttachType = (class_3867)state.method_11654(ATTACHMENT);
        class_2350 direction2 = Gong.getConnectedDirection(state).method_10153();
        if (direction2 == direction && !state.method_26184((class_4538)level, pos) && bellAttachType != class_3867.field_17101) {
            return class_2246.field_10124.method_9564();
        }
        if (direction.method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
            if (bellAttachType == class_3867.field_17101 && !neighborState.method_26206((class_1922)level, neighborPos, direction)) {
                return (class_2680)((class_2680)state.method_11657(ATTACHMENT, (Comparable)class_3867.field_17100)).method_11657((class_2769)FACING, (Comparable)direction.method_10153());
            }
            if (bellAttachType == class_3867.field_17100 && direction2.method_10153() == direction && neighborState.method_26206((class_1922)level, neighborPos, (class_2350)state.method_11654((class_2769)FACING))) {
                return (class_2680)state.method_11657(ATTACHMENT, (Comparable)class_3867.field_17101);
            }
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    private static class_2350 getConnectedDirection(class_2680 state) {
        switch ((class_3867)state.method_11654(ATTACHMENT)) {
            case field_17098: {
                return class_2350.field_11036;
            }
            case field_17099: {
                return class_2350.field_11033;
            }
        }
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (type == blockEntityInit.GONG_ENTITY_TYPE.get()) {
            return (lvl, pos, blockState, blockEntity) -> {
                if (blockEntity instanceof GongBlockEntity) {
                    GongBlockEntity gongBlockEntity = (GongBlockEntity)blockEntity;
                    GongBlockEntity.tick(lvl, pos, blockState, gongBlockEntity);
                }
            };
        }
        return null;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.fetzisasiandeco.shift_2"));
            tooltip.add((class_2561)class_2561.method_43473());
            class_5250 rangeValue = class_2561.method_43470((String)String.valueOf(FetzisAsianDecoConfig.getGongAttractRange())).method_27694(style -> style.method_10977(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.fetzisasiandeco.gong", (Object[])new Object[]{rangeValue}));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.fetzisasiandeco.shift_1"));
        }
    }
}

