/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.fabric.model;

import io.github.leonard1504.fabric.entity.custom.DoubleFramedBlockEntityFabric;
import io.github.leonard1504.util.FetzisAsianDecoQuadHelper;
import io.github.leonard1504.util.FetzisAsianDecoTextureSpriteCache;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BakedDoubleFramedModelFabric
implements FabricBakedModel,
class_1087 {
    private final class_1087 baseCubeModel;

    public BakedDoubleFramedModelFabric(class_1087 baseCubeModel) {
        this.baseCubeModel = baseCubeModel;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2586 entity = blockView.method_8321(pos);
        if (entity instanceof DoubleFramedBlockEntityFabric) {
            class_1058 newSprite2;
            DoubleFramedBlockEntityFabric framedEntity = (DoubleFramedBlockEntityFabric)entity;
            String texture1Id = framedEntity.getTexture1();
            String texture2Id = framedEntity.getTexture2();
            if (texture1Id == null) {
                this.emitDefaultQuads(state, randomSupplier, context);
                return;
            }
            class_1058 newSprite1 = FetzisAsianDecoTextureSpriteCache.getCachedTexture(texture1Id);
            if (newSprite1 == null) {
                newSprite1 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            if (texture2Id != null) {
                newSprite2 = FetzisAsianDecoTextureSpriteCache.getCachedTexture(texture2Id);
                if (newSprite2 == null) {
                    newSprite2 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSolidSprite();
                }
            } else {
                newSprite2 = FetzisAsianDecoTextureSpriteCache.getPlaceholderSolidSprite();
            }
            List quads = this.baseCubeModel.method_4707(state, null, randomSupplier.get());
            for (class_777 quad : quads) {
                QuadEmitter emitter = context.getEmitter();
                emitter.fromVanilla(quad, context.getEmitter().material(), null);
                if (quad.method_35788().method_45851().toString().contains("placeholder_frame") && newSprite1 != null) {
                    this.applyTextureToEmitter(quad, emitter, newSprite1);
                } else if (quad.method_35788().method_45851().toString().contains("placeholder_solid") && newSprite2 != null) {
                    this.applyTextureToEmitter(quad, emitter, newSprite2);
                }
                emitter.emit();
            }
        } else {
            this.baseCubeModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
    }

    private void emitDefaultQuads(class_2680 state, Supplier<class_5819> randomSupplier, RenderContext context) {
        List quads = this.baseCubeModel.method_4707(state, null, randomSupplier.get());
        for (class_777 quad : quads) {
            QuadEmitter emitter = context.getEmitter();
            emitter.fromVanilla(quad, context.getEmitter().material(), null);
            emitter.emit();
        }
    }

    private void applyTextureToEmitter(class_777 quad, QuadEmitter emitter, class_1058 newSprite) {
        int[] vertexData = quad.method_3357();
        for (int vertex = 0; vertex < 4; ++vertex) {
            float originalU = FetzisAsianDecoQuadHelper.getU(vertexData, vertex);
            float originalV = FetzisAsianDecoQuadHelper.getV(vertexData, vertex);
            float unInterpolatedU = FetzisAsianDecoQuadHelper.getUnInterpolatedU(quad.method_35788(), originalU);
            float unInterpolatedV = FetzisAsianDecoQuadHelper.getUnInterpolatedV(quad.method_35788(), originalV);
            float newU = newSprite.method_4580((double)unInterpolatedU);
            float newV = newSprite.method_4570((double)unInterpolatedV);
            emitter.uv(vertex, newU, newV);
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return List.of();
    }

    public boolean method_4708() {
        return this.baseCubeModel.method_4708();
    }

    public boolean method_4712() {
        return this.baseCubeModel.method_4712();
    }

    public boolean method_24304() {
        return this.baseCubeModel.method_24304();
    }

    public boolean method_4713() {
        return this.baseCubeModel.method_4713();
    }

    @NotNull
    public class_1058 method_4711() {
        return this.baseCubeModel.method_4711();
    }

    @NotNull
    public class_809 method_4709() {
        return this.baseCubeModel.method_4709();
    }

    @NotNull
    public class_806 method_4710() {
        return this.baseCubeModel.method_4710();
    }
}

