/*
 * Decompiled with CFR 0.152.
 */
package io.github.leonard1504.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;

public class FetzisAsianDecoTextureSpriteCache {
    private static final Map<String, CachedSprite> TEXTURE_CACHE = new ConcurrentHashMap<String, CachedSprite>();
    private static final Map<String, class_1058> BLOCK_TEXTURE_CACHE = new ConcurrentHashMap<String, class_1058>();
    private static final long CACHE_EXPIRY_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final int MAX_CACHE_SIZE = 256;
    private static long lastCleanup = System.currentTimeMillis();

    public static class_1058 getCachedTexture(String textureId) {
        if (textureId == null) {
            return null;
        }
        FetzisAsianDecoTextureSpriteCache.cleanupIfNeeded();
        CachedSprite cached = TEXTURE_CACHE.get(textureId);
        if (cached != null && !cached.isExpired()) {
            return cached.sprite;
        }
        class_1058 sprite = FetzisAsianDecoTextureSpriteCache.loadTexture(textureId);
        if (sprite != null) {
            TEXTURE_CACHE.put(textureId, new CachedSprite(sprite));
        }
        return sprite;
    }

    private static class_1058 loadTexture(String textureId) {
        try {
            String[] values = textureId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            class_2960 texture = new class_2960(values[0], "block/" + values[1]);
            class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(texture);
            if (sprite.method_45851().method_45816().toString().contains("missingno")) {
                return FetzisAsianDecoTextureSpriteCache.getFirstTextureFromBlock(textureId);
            }
            return sprite;
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error loading texture: " + textureId);
            return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
        }
    }

    public static class_1058 getFirstTextureFromBlock(String blockId) {
        class_1058 cached = BLOCK_TEXTURE_CACHE.get(blockId);
        if (cached != null) {
            return cached;
        }
        try {
            class_1058 sprite;
            String[] values = blockId.split(":");
            if (values.length != 2) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            class_2960 blockResource = new class_2960(values[0], values[1]);
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockResource);
            if (block == null || block.method_9564() == null) {
                return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
            }
            class_2680 defaultState = block.method_9564();
            class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(defaultState);
            for (class_2350 direction : class_2350.values()) {
                class_1058 sprite2;
                List quads = model.method_4707(defaultState, direction, class_5819.method_43047());
                if (quads.isEmpty() || quads.get(0) == null || (sprite2 = ((class_777)quads.get(0)).method_35788()) == null) continue;
                BLOCK_TEXTURE_CACHE.put(blockId, sprite2);
                return sprite2;
            }
            List generalQuads = model.method_4707(defaultState, null, class_5819.method_43047());
            if (!generalQuads.isEmpty() && generalQuads.get(0) != null && (sprite = ((class_777)generalQuads.get(0)).method_35788()) != null) {
                BLOCK_TEXTURE_CACHE.put(blockId, sprite);
                return sprite;
            }
        }
        catch (Exception e) {
            System.err.println("[Fetzi's Asian Deco] Error extracting texture from block: " + blockId);
        }
        return FetzisAsianDecoTextureSpriteCache.getPlaceholderSprite();
    }

    public static class_1058 getPlaceholderSprite() {
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("fetzisasiandeco", "block/placeholder_frame"));
    }

    public static class_1058 getPlaceholderSolidSprite() {
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("fetzisasiandeco", "block/placeholder_solid"));
    }

    private static void cleanupIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - lastCleanup < 30000L) {
            return;
        }
        lastCleanup = now;
        TEXTURE_CACHE.entrySet().removeIf(entry -> ((CachedSprite)entry.getValue()).isExpired());
        if (TEXTURE_CACHE.size() > 256) {
            TEXTURE_CACHE.entrySet().stream().sorted((e1, e2) -> Long.compare(((CachedSprite)e1.getValue()).timestamp, ((CachedSprite)e2.getValue()).timestamp)).limit(TEXTURE_CACHE.size() - 256).forEach(entry -> TEXTURE_CACHE.remove(entry.getKey()));
        }
        if (BLOCK_TEXTURE_CACHE.size() > 256) {
            BLOCK_TEXTURE_CACHE.clear();
        }
    }

    public static void clearCaches() {
        TEXTURE_CACHE.clear();
        BLOCK_TEXTURE_CACHE.clear();
        lastCleanup = System.currentTimeMillis();
    }

    private static class CachedSprite {
        final class_1058 sprite;
        final long timestamp;

        CachedSprite(class_1058 sprite) {
            this.sprite = sprite;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > CACHE_EXPIRY_MS;
        }
    }
}

