/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.statement.api.StatementApi;
import virtuoel.statement.api.StatementConfig;
import virtuoel.statement.network.StatementPacketHandler;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;
import virtuoel.statement.util.config.InvalidatableLazySupplier;
import virtuoel.statement.util.config.JsonConfigBuilder;
import virtuoel.statement.util.config.JsonConfigHandler;
import virtuoel.statement.util.config.MutableConfigEntry;

@Mod(value="statement")
@ApiStatus.Internal
public class Statement
implements StatementApi {
    public static final String MOD_ID = "statement";
    public static final ILogger LOGGER = MixinService.getService().getLogger("statement");
    public static final ResourceLocation BLOCK_STATE_VALIDATION_PACKET = Statement.id("block_state_validation");
    public static final ResourceLocation FLUID_STATE_VALIDATION_PACKET = Statement.id("fluid_state_validation");

    public Statement() {
        ((JsonConfigHandler)StatementConfig.BUILDER.config).get();
        StatementApi.ENTRYPOINTS.add(this);
        StatementPacketHandler.init();
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void markRegistryAsModded(Registry<?> registry) {
    }

    public static <S> MutableConfigEntry<Set<S>> createSetConfig(JsonConfigBuilder builder, String name, Function<Supplier<JsonObject>, Supplier<Set<S>>> entryGetterFunction) {
        return builder.customConfig(name, config -> arg_0 -> Statement.lambda$createSetConfig$0((Supplier)config, name, arg_0), Collections.emptySet(), entryGetterFunction);
    }

    public static Supplier<Set<BlockState>> createBlockStateDeferralConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateDeferralData(config, "customBlockStateDeferral", RegistryUtils.BLOCK_REGISTRY, Block::m_49965_));
    }

    public static Supplier<Set<FluidState>> createFluidStateDeferralConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateDeferralData(config, "customFluidStateDeferral", RegistryUtils.FLUID_REGISTRY, Fluid::m_76144_));
    }

    private static <O, S extends StateHolder<O, S>> Set<S> loadStateDeferralData(Supplier<JsonObject> config, String member, Registry<O> registry, Function<O, StateDefinition<O, S>> managerFunc) {
        JsonObject data = Optional.ofNullable(config.get().get(member)).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
        HashSet deferralData = new HashSet();
        for (Map.Entry e : data.entrySet()) {
            RegistryUtils.getOrEmpty(registry, new ResourceLocation((String)e.getKey())).ifPresent(block -> {
                JsonArray states = Optional.ofNullable((JsonElement)e.getValue()).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).orElseGet(JsonArray::new);
                StateDefinition manager = (StateDefinition)managerFunc.apply(block);
                for (JsonElement s : states) {
                    if (!s.isJsonObject()) continue;
                    JsonObject stateSyncData = s.getAsJsonObject();
                    JsonObject properties = Optional.ofNullable(stateSyncData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    HashMap predicates = new HashMap();
                    for (Map.Entry p : properties.entrySet()) {
                        Property property = manager.m_61081_((String)p.getKey());
                        if (property == null) continue;
                        ((StatementPropertyExtensions)property).statement_parse(((JsonElement)p.getValue()).getAsString()).ifPresent(val -> predicates.put(property, val::equals));
                    }
                    manager.m_61056_().stream().filter(st -> predicates.entrySet().stream().allMatch(en -> ((Predicate)en.getValue()).test(st.m_61143_((Property)en.getKey())))).forEach(deferralData::add);
                }
            });
        }
        return deferralData;
    }

    public static <S> boolean shouldStateBeDeferred(IdMapper<S> idList, S state) {
        if (StatementConfig.COMMON.enableStateDeferralApi.get().booleanValue()) {
            for (StatementApi api : StatementApi.ENTRYPOINTS) {
                if (!api.shouldDeferState(idList, state)) continue;
                return true;
            }
        } else {
            if (idList == Block.f_49791_) {
                return StatementConfig.COMMON.customBlockStateDeferral.get().contains(state);
            }
            if (idList == Fluid.f_76104_) {
                return StatementConfig.COMMON.customFluidStateDeferral.get().contains(state);
            }
        }
        return false;
    }

    @Override
    public <S> boolean shouldDeferState(IdMapper<S> idList, S state) {
        if (idList == Block.f_49791_) {
            return StatementConfig.COMMON.customBlockStateDeferral.get().contains(state);
        }
        if (idList == Fluid.f_76104_) {
            return StatementConfig.COMMON.customFluidStateDeferral.get().contains(state);
        }
        return StatementApi.super.shouldDeferState(idList, state);
    }

    public static OptionalInt getSyncedBlockStateId(@Nullable int id) {
        return Statement.getSyncedStateId(Block.f_49791_, id);
    }

    public static OptionalInt getSyncedBlockStateId(@Nullable BlockState state) {
        return Statement.getSyncedStateId(Block.f_49791_, state);
    }

    public static OptionalInt getSyncedFluidStateId(@Nullable int id) {
        return Statement.getSyncedStateId(Fluid.f_76104_, id);
    }

    public static OptionalInt getSyncedFluidStateId(@Nullable FluidState state) {
        return Statement.getSyncedStateId(Fluid.f_76104_, state);
    }

    public static <S> OptionalInt getSyncedStateId(IdMapper<S> idList, int id) {
        return Statement.getSyncedStateId(idList, id, IdMapper::m_7447_, IdMapper::m_7942_, IdMapper::m_13562_);
    }

    public static <S> OptionalInt getSyncedStateId(IdMapper<S> idList, @Nullable S state) {
        return Statement.getSyncedStateId(idList, state, IdMapper::m_7447_, IdMapper::m_7942_, IdMapper::m_13562_);
    }

    public static <S, L extends Iterable<S>> OptionalInt getSyncedStateId(L idList, int id, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        return Statement.getSyncedStateId(idList, getFunc.apply(idList, id), idFunc, getFunc, sizeFunc);
    }

    public static <S, L extends Iterable<S>> OptionalInt getSyncedStateId(L idList, @Nullable S state, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        if (state != null) {
            if (StatementConfig.COMMON.enableIdSyncApi.get().booleanValue()) {
                for (StatementApi api : StatementApi.ENTRYPOINTS) {
                    OptionalInt syncedId = api.getSyncedId(idList, state, idFunc, getFunc, sizeFunc);
                    if (!syncedId.isPresent()) continue;
                    return syncedId;
                }
            } else {
                if (idList == Block.f_49791_) {
                    return StatementConfig.COMMON.customBlockStateSync.get().getOrDefault(state, OptionalInt.empty());
                }
                if (idList == Fluid.f_76104_) {
                    return StatementConfig.COMMON.customFluidStateSync.get().getOrDefault(state, OptionalInt.empty());
                }
            }
        }
        return OptionalInt.empty();
    }

    public static <K, V> MutableConfigEntry<Map<K, V>> createMapConfig(JsonConfigBuilder builder, String name, Function<Supplier<JsonObject>, Supplier<Map<K, V>>> entryGetterFunction) {
        return builder.customConfig(name, config -> arg_0 -> Statement.lambda$createMapConfig$8((Supplier)config, name, arg_0), Collections.emptyMap(), entryGetterFunction);
    }

    public static Supplier<Map<BlockState, OptionalInt>> createBlockStateSyncConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateSyncData(config, "customBlockStateSync", Block.f_49791_, RegistryUtils.BLOCK_REGISTRY, Block::m_49965_, Block::m_49966_));
    }

    public static Supplier<Map<FluidState, OptionalInt>> createFluidStateSyncConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateSyncData(config, "customFluidStateSync", Fluid.f_76104_, RegistryUtils.FLUID_REGISTRY, Fluid::m_76144_, Fluid::m_76145_));
    }

    private static <O, S extends StateHolder<O, S>> Map<S, OptionalInt> loadStateSyncData(Supplier<JsonObject> config, String member, IdMapper<S> idList, Registry<O> registry, Function<O, StateDefinition<O, S>> managerFunc, Function<O, S> defaultStateFunc) {
        JsonObject data = Optional.ofNullable(config.get().get(member)).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
        HashMap syncData = new HashMap();
        Function<ResourceLocation, Optional> getOrEmpty = id -> RegistryUtils.getOrEmpty(registry, id);
        for (Map.Entry e : data.entrySet()) {
            getOrEmpty.apply(new ResourceLocation((String)e.getKey())).ifPresent(block -> {
                JsonArray states = Optional.ofNullable((JsonElement)e.getValue()).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).orElseGet(JsonArray::new);
                StateDefinition manager = (StateDefinition)managerFunc.apply(block);
                for (JsonElement s : states) {
                    Function<StateHolder, Integer> stateIdFunc;
                    if (!s.isJsonObject()) continue;
                    JsonObject stateSyncData = s.getAsJsonObject();
                    JsonObject properties = Optional.ofNullable(stateSyncData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    JsonObject syncedStateData = Optional.ofNullable(stateSyncData.get("syncedState")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    Optional<ResourceLocation> syncedBlockId = Optional.ofNullable(syncedStateData.get("name")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).map(ResourceLocation::new);
                    JsonObject syncedStateProperties = Optional.ofNullable(syncedStateData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    if (syncedBlockId.isPresent()) {
                        StateHolder syncedState = syncedBlockId.map(getOrEmpty).orElseGet(Optional::empty).map(defaultStateFunc).orElse(null);
                        if (syncedState != null) {
                            int id = idList.m_7447_((Object)Statement.getStateWithProperties(manager, syncedState, syncedStateProperties.entrySet()));
                            stateIdFunc = state -> id;
                        } else {
                            stateIdFunc = state -> -1;
                        }
                    } else {
                        stateIdFunc = state -> idList.m_7447_((Object)Statement.getStateWithProperties(manager, state, syncedStateProperties.entrySet()));
                    }
                    OptionalInt syncedId = Optional.ofNullable(stateSyncData.get("syncedId")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isNumber).map(JsonPrimitive::getAsInt).map(OptionalInt::of).orElseGet(OptionalInt::empty);
                    HashMap predicates = new HashMap();
                    for (Map.Entry p : properties.entrySet()) {
                        Property property = manager.m_61081_((String)p.getKey());
                        if (property == null) continue;
                        ((StatementPropertyExtensions)property).statement_parse(((JsonElement)p.getValue()).getAsString()).ifPresent(val -> predicates.put(property, val::equals));
                    }
                    manager.m_61056_().stream().filter(st -> predicates.entrySet().stream().allMatch(en -> ((Predicate)en.getValue()).test(st.m_61143_((Property)en.getKey())))).forEach(st -> {
                        int id = (Integer)stateIdFunc.apply((StateHolder)st);
                        syncData.put(st, id == -1 ? syncedId : OptionalInt.of(id));
                    });
                }
            });
        }
        return syncData;
    }

    private static <O, S extends StateHolder<O, S>> S getStateWithProperties(StateDefinition<O, S> manager, S state, Set<Map.Entry<String, JsonElement>> properties) {
        for (Map.Entry<String, JsonElement> p : properties) {
            Optional value;
            Property property = manager.m_61081_(p.getKey());
            if (property == null || !(value = ((StatementPropertyExtensions)property).statement_parse(p.getValue().getAsString())).isPresent()) continue;
            state = (StateHolder)((StatementStateExtensions)state).statement_with(property, (Comparable)value.get());
        }
        return state;
    }

    @Override
    public <S, L extends Iterable<S>> OptionalInt getSyncedId(L idList, @Nullable S state, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        if (idList == Block.f_49791_) {
            return StatementConfig.COMMON.customBlockStateSync.get().getOrDefault(state, OptionalInt.empty());
        }
        if (idList == Fluid.f_76104_) {
            return StatementConfig.COMMON.customFluidStateSync.get().getOrDefault(state, OptionalInt.empty());
        }
        return OptionalInt.empty();
    }

    public static void invalidateCustomStateData(IdMapper<?> idList) {
        if (idList == Block.f_49791_) {
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customBlockStateDeferral).invalidate();
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customBlockStateSync).invalidate();
        } else if (idList == Fluid.f_76104_) {
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customFluidStateDeferral).invalidate();
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customFluidStateSync).invalidate();
        }
    }

    private static /* synthetic */ void lambda$createMapConfig$8(Supplier config, String name, Map v) {
        if (v.isEmpty()) {
            ((JsonObject)config.get()).add(name, (JsonElement)new JsonObject());
        }
    }

    private static /* synthetic */ void lambda$createSetConfig$0(Supplier config, String name, Set v) {
        if (v.isEmpty()) {
            ((JsonObject)config.get()).add(name, (JsonElement)new JsonObject());
        }
    }
}

