/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin.compat115minus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.statement.Statement;
import virtuoel.statement.util.HydrogenCompatibility;
import virtuoel.statement.util.StatementStateExtensions;

@Mixin(targets={"net.minecraft.class_2679"}, remap=false)
public abstract class AbstractStateMixin<O, S>
implements StatementStateExtensions<S> {
    @Shadow(remap=false)
    @Final
    @Mutable
    protected O field_12287;
    @Shadow(remap=false)
    @Final
    @Mutable
    private ImmutableMap<Property<?>, Comparable<?>> field_12285;
    @Shadow(remap=false)
    private Table<Property<?>, Comparable<?>, S> field_12288;
    @Unique
    String getMissingOwner = "";
    @Unique
    String withMissingOwner = "";
    @Unique
    String withDisallowedOwner = "";
    @Unique
    final Map<Property<?>, Comparable<?>> cachedFallbacks = new HashMap();

    @Inject(method={"method_11654"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")}, remap=false)
    private <T extends Comparable<T>> void onGet(Property<T> property, CallbackInfoReturnable<T> info) {
        String ownerString = this.field_12287.toString();
        if (!this.getMissingOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot get property {} as it does not exist in {}", new Object[]{property, this.field_12287});
            this.getMissingOwner = ownerString;
        }
        info.setReturnValue((Object)(this.cachedFallbacks.containsKey(property) ? (Comparable)property.m_61709_().cast(this.cachedFallbacks.get(property)) : (Comparable)property.m_6908_().iterator().next()));
    }

    @Inject(method={"method_11657"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")}, remap=false)
    private <T extends Comparable<T>, V extends T> void onWith(Property<T> property, V value, CallbackInfoReturnable<Object> info) {
        String ownerString = this.field_12287.toString();
        if (this.field_12285.get(property) == null) {
            if (!this.withMissingOwner.equals(ownerString)) {
                Statement.LOGGER.info("Cannot set property {} as it does not exist in {}", new Object[]{property, this.field_12287});
                this.withMissingOwner = ownerString;
            }
        } else if (!this.withDisallowedOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot set property {} to {} on {}, it is not an allowed value", new Object[]{property, value, this.field_12287});
            this.withDisallowedOwner = ownerString;
        }
        info.setReturnValue((Object)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_11571"}, remap=false)
    private void onCreateWithTable(Map<Map<Property<?>, Comparable<?>>, S> map, CallbackInfo info) {
        this.field_12288 = null;
    }

    @Shadow(remap=false)
    abstract void method_11571(Map<Map<Property<?>, Comparable<?>>, ?> var1);

    @Override
    public void statement_createWithTable(Map<Map<Property<?>, Comparable<?>>, ?> states) {
        this.method_11571(states);
    }

    @Shadow(remap=false)
    abstract ImmutableMap<Property<?>, Comparable<?>> method_11656();

    @Override
    public ImmutableMap<Property<?>, Comparable<?>> statement_getEntries() {
        return this.method_11656();
    }

    @Shadow
    abstract <T extends Comparable<T>, V extends T> S method_11657(Property<T> var1, V var2);

    @Override
    public <T extends Comparable<T>, V extends T> S statement_with(Property<T> property, V value) {
        return this.method_11657(property, value);
    }

    @Override
    public <V extends Comparable<V>> boolean statement_addEntry(Property<V> property, V value) {
        if (!this.field_12285.containsKey(property)) {
            this.statement_setEntries(ImmutableMap.builder().putAll(this.field_12285).put(property, value).build());
            return true;
        }
        return false;
    }

    @Override
    public <V extends Comparable<V>> boolean statement_removeEntry(Property<V> property) {
        if (this.field_12285.containsKey(property)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.field_12285.entrySet()) {
                Property key = (Property)entry.getKey();
                if (key == property) continue;
                builder.put((Object)key, (Object)((Comparable)entry.getValue()));
            }
            this.cachedFallbacks.put(property, (Comparable)this.field_12285.get(property));
            this.statement_setEntries(builder.build());
            return true;
        }
        return false;
    }

    @Override
    public void statement_setEntries(ImmutableMap<Property<?>, Comparable<?>> entries) {
        this.field_12285 = HydrogenCompatibility.INSTANCE.wrapEntries(entries);
    }
}

