/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.statement.Statement;
import virtuoel.statement.api.StateRefresher;
import virtuoel.statement.util.CommandUtils;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementBlockStateExtensions;
import virtuoel.statement.util.StatementFluidStateExtensions;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;

@Mod.EventBusSubscriber(modid="statement")
public class FabricApiCompatibility {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        if (event.getServer().m_6982_()) {
            StateRefresher.INSTANCE.reorderBlockStates();
            StateRefresher.INSTANCE.reorderFluidStates();
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        FabricApiCompatibility.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"statement").requires(commandSource -> commandSource.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"validate").then(FabricApiCompatibility.stateValidationArgument("block_state", Statement.BLOCK_STATE_VALIDATION_PACKET))).then(FabricApiCompatibility.stateValidationArgument("fluid_state", Statement.FLUID_STATE_VALIDATION_PACKET)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get_id").then(FabricApiCompatibility.idGetterArgument("block_state", Block.f_49791_, BlockGetter::m_8055_, RegistryUtils.BLOCK_REGISTRY, s -> ((StatementBlockStateExtensions)s).statement_getBlock()))).then(FabricApiCompatibility.idGetterArgument("fluid_state", Fluid.f_76104_, BlockGetter::m_6425_, RegistryUtils.FLUID_REGISTRY, s -> ((StatementFluidStateExtensions)s).statement_getFluid()))));
        if (!FMLLoader.isProduction()) {
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"statement").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"run_mixin_tests").executes(context -> {
                MixinEnvironment.getCurrentEnvironment().audit();
                return 1;
            }))));
        }
    }

    private static <O, S extends StateHolder<O, S>> ArgumentBuilder<CommandSourceStack, ?> idGetterArgument(String argumentName, IdMapper<S> idList, BiFunction<ServerLevel, BlockPos, S> stateFunc, Registry<O> registry, Function<S, O> entryFunction) {
        return Commands.m_82127_((String)argumentName).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)context, (String)"pos");
            StateHolder state = (StateHolder)stateFunc.apply(((CommandSourceStack)context.getSource()).m_81372_(), pos);
            ImmutableMap<Property<?>, Comparable<?>> entries = ((StatementStateExtensions)state).statement_getEntries();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RegistryUtils.getId(registry, entryFunction.apply(state)));
            if (!entries.isEmpty()) {
                stringBuilder.append('[');
                stringBuilder.append(entries.entrySet().stream().map(entry -> {
                    StatementPropertyExtensions property = (StatementPropertyExtensions)entry.getKey();
                    return property.statement_getName() + "=" + property.statement_name(entry.getValue());
                }).collect(Collectors.joining(",")));
                stringBuilder.append(']');
            }
            CommandUtils.sendFeedback((CommandSourceStack)context.getSource(), () -> FabricApiCompatibility.literal("%s (%d) @ %d, %d, %d", stringBuilder.toString(), idList.m_7447_((Object)state), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), false);
            return 1;
        }));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> stateValidationArgument(String argumentName, ResourceLocation packetId) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)argumentName).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<CommandSourceStack>)context, packetId, ((CommandSourceStack)context.getSource()).m_230896_(), 100, 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<CommandSourceStack>)context, packetId, EntityArgument.m_91474_((CommandContext)context, (String)"player"), 100, 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"rate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Block.f_49791_.m_13562_())).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<CommandSourceStack>)context, packetId, EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rate"), 0))).then(Commands.m_82129_((String)"start_id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(Block.f_49791_.m_13562_() - 1))).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<CommandSourceStack>)context, packetId, EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rate"), IntegerArgumentType.getInteger((CommandContext)context, (String)"start_id"))))));
    }

    private static int executeValidation(CommandContext<CommandSourceStack> context, ResourceLocation packetId, ServerPlayer player, int rate, int initialId) throws CommandSyntaxException {
        return 1;
    }

    private static Component literal(String value, Object ... args) {
        return Component.m_237113_((String)String.format(value, args));
    }

    public static CompoundTag fromFluidState(FluidState state) {
        return FabricApiCompatibility.fromState(RegistryUtils.FLUID_REGISTRY, s -> ((StatementFluidStateExtensions)s).statement_getFluid(), state);
    }

    public static <S extends StateHolder<?, S>, E> CompoundTag fromState(Registry<E> registry, Function<S, E> entryFunction, S state) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Name", RegistryUtils.getId(registry, entryFunction.apply(state)).toString());
        ImmutableMap<Property<?>, Comparable<?>> entries = ((StatementStateExtensions)state).statement_getEntries();
        if (!entries.isEmpty()) {
            CompoundTag properties = new CompoundTag();
            for (Map.Entry entry : entries.entrySet()) {
                StatementPropertyExtensions property = (StatementPropertyExtensions)entry.getKey();
                String valueName = property.statement_name(entry.getValue());
                properties.m_128359_(property.statement_getName(), valueName);
            }
            compound.m_128365_("Properties", (Tag)properties);
        }
        return compound;
    }
}

