/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import virtuoel.statement.api.compatibility.FoamFixCompatibility;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.ReflectionUtils;

public class FoamFixCompatibilityImpl
implements FoamFixCompatibility {
    private static final boolean FOAMFIX_LOADED = ModLoaderUtils.isModLoaded("foamfix");
    private final Optional<Class<?>> orderingClass;
    private final Optional<Class<?>> factoryClass;
    private final Optional<Class<?>> stateClass;
    private final Optional<Class<?>> valueMapperClass;
    private final Optional<Map<Property<?>, ?>> propertyEntryMap;
    private final Optional<Field> factoryMapper;
    private final Optional<Field> stateOwner;
    private boolean enabled = FOAMFIX_LOADED;

    public FoamFixCompatibilityImpl() {
        if (this.enabled) {
            this.orderingClass = ReflectionUtils.getClass("pl.asie.foamfix.state.PropertyOrdering");
            this.factoryClass = ReflectionUtils.getClass("pl.asie.foamfix.state.FoamyStateFactory$Factory");
            this.stateClass = ReflectionUtils.getClass("pl.asie.foamfix.state.FoamyBlockStateMapped");
            this.valueMapperClass = ReflectionUtils.getClass("pl.asie.foamfix.state.PropertyValueMapperImpl");
            this.propertyEntryMap = ReflectionUtils.getField(this.orderingClass, "entryMap").map(f -> {
                try {
                    Map map = (Map)f.get(null);
                    return map;
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    return null;
                }
            });
            this.factoryMapper = ReflectionUtils.getField(this.factoryClass, "mapper");
            this.stateOwner = ReflectionUtils.getField(this.stateClass, "owner");
        } else {
            this.orderingClass = Optional.empty();
            this.factoryClass = Optional.empty();
            this.stateClass = Optional.empty();
            this.valueMapperClass = Optional.empty();
            this.propertyEntryMap = Optional.empty();
            this.factoryMapper = Optional.empty();
            this.stateOwner = Optional.empty();
        }
    }

    @Override
    public void enable() {
        this.enabled = FOAMFIX_LOADED;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void removePropertyFromEntryMap(Property<?> property) {
        if (this.isEnabled()) {
            this.propertyEntryMap.ifPresent(map -> map.remove(property));
        }
    }

    @Override
    public Optional<Object> constructPropertyValueMapper(Collection<Property<?>> properties) {
        if (this.isEnabled()) {
            return this.valueMapperClass.map(c -> FoamFixCompatibilityImpl.constructPropertyValueMapper(c, properties));
        }
        return Optional.empty();
    }

    @Nullable
    private static Object constructPropertyValueMapper(Class<?> clazz, Collection<Property<?>> properties) {
        try {
            return clazz.getConstructor(Collection.class).newInstance(properties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public void setFactoryMapper(Optional<?> factory, Optional<?> mapper) {
        if (this.isEnabled()) {
            mapper.ifPresent(m -> factory.ifPresent(f -> this.factoryClass.filter(c -> c.isInstance(f)).flatMap(c -> this.factoryMapper).ifPresent(field -> {
                try {
                    field.set(f, m);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            })));
        }
    }

    @Override
    public void setStateOwner(StateHolder<?, ?> state, Optional<?> owner) {
        if (this.isEnabled()) {
            owner.ifPresent(o -> this.stateClass.filter(c -> c.isInstance(state)).flatMap(c -> this.stateOwner).ifPresent(f -> {
                try {
                    f.set(state, o);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }));
        }
    }
}

