/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.IdMapper;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.ReflectionUtils;

public class PolymerCompatibility {
    private static final boolean POLYMER_CORE_LOADED = ModLoaderUtils.isModLoaded("polymer-core");
    private static final Optional<Class<?>> POLYMER_ID_LIST_CLASS = POLYMER_CORE_LOADED ? ReflectionUtils.getClass("eu.pb4.polymer.core.impl.interfaces.PolymerIdList") : Optional.empty();
    private static final Optional<Method> SET_IGNORE_CALLS = POLYMER_CORE_LOADED ? ReflectionUtils.getMethod(POLYMER_ID_LIST_CLASS, "polymer$setIgnoreCalls", Boolean.TYPE) : Optional.empty();
    private static final Optional<Method> CLEAR = POLYMER_CORE_LOADED ? ReflectionUtils.getMethod(POLYMER_ID_LIST_CLASS, "polymer$clear", new Class[0]) : Optional.empty();

    public static void preRecalculation(IdMapper<?> idList) {
        if (POLYMER_CORE_LOADED) {
            SET_IGNORE_CALLS.ifPresent(m -> {
                try {
                    m.invoke((Object)idList, true);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            });
            CLEAR.ifPresent(m -> {
                try {
                    m.invoke((Object)idList, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            });
        }
    }

    public static void postRecalculation(IdMapper<?> idList) {
        if (POLYMER_CORE_LOADED) {
            SET_IGNORE_CALLS.ifPresent(m -> {
                try {
                    m.invoke((Object)idList, false);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            });
        }
    }
}

