/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util.config;

import java.util.Objects;
import java.util.function.Supplier;

public final class InvalidatableLazySupplier<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private boolean valid = false;
    private T value;

    public static <T> InvalidatableLazySupplier<T> of(Supplier<T> delegate) {
        if (delegate instanceof InvalidatableLazySupplier) {
            return (InvalidatableLazySupplier)delegate;
        }
        return new InvalidatableLazySupplier<T>(delegate);
    }

    private InvalidatableLazySupplier(Supplier<T> delegate) {
        this.supplier = Objects.requireNonNull(delegate);
    }

    public final void invalidate() {
        this.valid = false;
    }

    @Override
    public final T get() {
        if (!this.valid) {
            T t = this.supplier.get();
            this.value = t;
            this.valid = true;
            return t;
        }
        return this.value;
    }
}

