/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.common.block.scented_candles;

import com.davigj.whiffowisp.common.block.scented_candles.ScentedCandleBlock;
import com.davigj.whiffowisp.core.WOWConfig;
import com.davigj.whiffowisp.core.registry.WOWSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DistantSongCandleBlock
extends ScentedCandleBlock {
    public DistantSongCandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void affect(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        super.affect(level, pos, state, entity);
        if (entity instanceof Player && (player = (Player)entity).m_6047_()) {
            return;
        }
        if (entity instanceof ItemEntity && !((Boolean)WOWConfig.COMMON.distantSongTeleportsItems.get()).booleanValue()) {
            return;
        }
        int d = (Integer)WOWConfig.COMMON.distantSongTeleportDistance.get();
        switch ((Integer)state.m_61143_((Property)f_152790_)) {
            case 1: {
                DistantSongCandleBlock.teleport(entity, level, pos, 0, -d);
                break;
            }
            case 2: {
                DistantSongCandleBlock.teleport(entity, level, pos, -d, 0);
                break;
            }
            case 3: {
                DistantSongCandleBlock.teleport(entity, level, pos, 0, d);
                break;
            }
            case 4: {
                DistantSongCandleBlock.teleport(entity, level, pos, d, 0);
            }
        }
    }

    public static void teleport(Entity entity, Level level, BlockPos candlePos, int xOffset, int zOffset) {
        int tries;
        BlockPos startPos = entity.m_20183_();
        BlockPos targetPos = DistantSongCandleBlock.findPos(startPos, level, xOffset, zOffset);
        if (targetPos == null) {
            return;
        }
        double x = (double)targetPos.m_123341_() + 0.5;
        double y = targetPos.m_123342_();
        double z = (double)targetPos.m_123343_() + 0.5;
        for (tries = 0; !level.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60795_() && tries < 5; ++tries) {
            y += 1.0;
        }
        if (tries == 4 || entity.m_20159_() || entity.m_20160_()) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                DistantSongCandleBlock.failTeleport(living, level, candlePos);
            }
            return;
        }
        int j = 6;
        if (!level.f_46443_) {
            entity.m_6021_(x, y + 0.75, z);
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                item.m_20334_(0.0, item.m_20184_().f_82480_, 0.0);
                j = 2;
                item.f_19864_ = true;
            }
            float pitch = 1.0f + level.m_213780_().m_188501_();
            float volume = 0.3f;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_183634_();
                player.m_6330_((SoundEvent)WOWSounds.CANDLE_TP.get(), SoundSource.PLAYERS, volume, pitch);
                level.m_5594_(player, candlePos, (SoundEvent)WOWSounds.CANDLE_TP.get(), SoundSource.BLOCKS, volume, pitch);
            } else {
                level.m_5594_(null, candlePos, (SoundEvent)WOWSounds.CANDLE_TP.get(), SoundSource.BLOCKS, volume, pitch);
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.m_213780_();
            for (int i = 0; i < j; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)candlePos.m_123341_() + 0.5 + random.m_188583_() * 0.25, (double)candlePos.m_123342_() + 0.67, (double)candlePos.m_123343_() + 0.5 + random.m_188583_() * 0.25, 1, 0.0, 0.02, 0.0, 0.0);
            }
        }
    }

    private static void failTeleport(LivingEntity living, Level level, BlockPos candlePos) {
        if (living.f_19797_ % 20 != 0) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.m_213780_();
            for (int i = 0; i < 6; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)candlePos.m_123341_() + 0.5 + random.m_188583_() * 0.3, (double)candlePos.m_123342_() + 1.0, (double)candlePos.m_123343_() + 0.5 + random.m_188583_() * 0.3, 1, 0.0, 0.02, 0.0, 0.0);
            }
            serverLevel.m_5594_(null, candlePos, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.3f, 4.0f);
        } else {
            living.m_6469_(living.m_269291_().m_269425_(), 1.0f);
        }
    }

    private static BlockPos findPos(BlockPos startPos, Level level, int xOffset, int zOffset) {
        BlockPos pos = startPos.m_7918_(xOffset, 0, zOffset);
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() <= level.m_151558_() ? pos : null;
    }
}

