/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.common.block.scented_candles;

import com.davigj.whiffowisp.common.block.scented_candles.ScentedCandleBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ScentedEffectCandleBlock
extends ScentedCandleBlock {
    String modid;
    ResourceLocation effect;
    int amplifier;

    public ScentedEffectCandleBlock(BlockBehaviour.Properties properties, String modid, ResourceLocation effect, int amplifier) {
        super(properties);
        this.modid = modid;
        this.effect = effect;
        this.amplifier = amplifier;
    }

    public ScentedEffectCandleBlock(BlockBehaviour.Properties properties, String modid, ResourceLocation effect) {
        super(properties);
        this.modid = modid;
        this.effect = effect;
        this.amplifier = 0;
    }

    @Override
    public void affect(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.affect(level, pos, state, entity);
        if (!level.f_46443_ && ModList.get().isLoaded(this.modid) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (ScentedEffectCandleBlock.getCompatEffect(this.modid, this.effect).get() != null) {
                living.m_7292_(new MobEffectInstance(new MobEffectInstance(ScentedEffectCandleBlock.getCompatEffect(this.modid, this.effect).get(), 10 + 20 * (Integer)state.m_61143_((Property)f_152790_), this.amplifier)));
            }
        }
    }

    public static Supplier<MobEffect> getCompatEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effect) : () -> null;
    }
}

