/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class WOWConfig {
    static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> scentFX;
        public final ForgeConfigSpec.ConfigValue<Boolean> redRedemptionTrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> softBlanketTrade;
        public final ForgeConfigSpec.ConfigValue<Boolean> caravanSpiceTrade;
        public final ForgeConfigSpec.ConfigValue<Integer> dailySpecialDuration;
        public final ForgeConfigSpec.ConfigValue<Boolean> distantSongTeleportsItems;
        public final ForgeConfigSpec.ConfigValue<Integer> distantSongTeleportDistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> blackCherryBoost;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            builder.push("candles");
            this.scentFX = builder.comment("Do scented candles affect living entities").define("Scent FX", true);
            this.dailySpecialDuration = builder.comment("Ticks per day for daily scented candles").define("Daily special duration", (Object)24000);
            this.distantSongTeleportsItems = builder.comment("Can Distant Song Scented Candles teleport items").define("Distant Song teleports items", false);
            this.distantSongTeleportDistance = builder.comment("Horizontal teleport distance for distant song candles (in blocks)").defineInRange("Distant song teleport distance", 6, 1, 64);
            builder.push("candles");
            this.blackCherryBoost = builder.comment("Do Black Cherry Scented Candles boost nearby darkness cloak wearers").define("Black Cherry darkness boost", true);
            builder.pop();
            builder.pop();
            builder.push("trades");
            this.redRedemptionTrade = builder.comment("Do expert butchers trade red redemption candles").define("Red redemption trade", true);
            this.softBlanketTrade = builder.comment("Do expert butchers trade soft blanket candles").define("Soft blanket trade", true);
            this.caravanSpiceTrade = builder.comment("Do wandering traders trade caravan spice candles").define("Caravan spice trade", true);
            builder.pop();
            builder.pop();
        }
    }
}

