/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.whiffowisp.core;

import com.davigj.whiffowisp.core.WOWConfig;
import com.davigj.whiffowisp.core.data.client.WOWBlockStateProvider;
import com.davigj.whiffowisp.core.data.client.WOWItemModelProvider;
import com.davigj.whiffowisp.core.data.server.WOWBlockTagsProvider;
import com.davigj.whiffowisp.core.data.server.WOWLootTableProvider;
import com.davigj.whiffowisp.core.data.server.WOWRecipeProvider;
import com.davigj.whiffowisp.core.other.WOWBlockStatements;
import com.davigj.whiffowisp.core.registry.WOWBlocks;
import com.davigj.whiffowisp.core.registry.WOWItems;
import com.davigj.whiffowisp.core.registry.WOWParticleTypes;
import com.davigj.whiffowisp.core.registry.WOWSounds;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="whiffowisp")
public class WhiffOWisp {
    public static final String MOD_ID = "whiffowisp";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("whiffowisp");

    public WhiffOWisp() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> WOWItems::buildCreativeTabContents);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> WOWBlocks::buildCreativeTabContents);
        REGISTRY_HELPER.register(bus);
        WOWParticleTypes.PARTICLE_TYPES.register(bus);
        WOWSounds.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WOWConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> WOWBlockStatements.addTrimStates());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        WOWBlockTagsProvider blockTags = new WOWBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new WOWLootTableProvider(output));
        generator.addProvider(server, (DataProvider)new WOWRecipeProvider(output));
        boolean includeClient = event.includeClient();
        generator.addProvider(includeClient, (DataProvider)new WOWItemModelProvider(output, helper));
        generator.addProvider(includeClient, (DataProvider)new WOWBlockStateProvider(output, helper));
    }

    public static ResourceLocation modLoc(String location) {
        return new ResourceLocation(MOD_ID, location);
    }
}

