/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import net.minecraft.class_265;
import net.minecraft.class_4970;
import org.dfood.block.FoodBlock;
import org.dfood.util.IntPropertyManager;
import org.jetbrains.annotations.Nullable;

public abstract class FoodBlockBuilder<T extends FoodBlock, B extends FoodBlockBuilder<T, B>> {
    protected class_4970.class_2251 settings;
    protected int maxFood = 1;
    protected boolean isFood = true;
    @Nullable
    protected FoodBlock.EnforceAsItem cItem = null;
    protected boolean useItemTranslationKey = true;
    @Nullable
    protected class_265 simpleShape = null;

    protected FoodBlockBuilder() {
    }

    public B settings(class_4970.class_2251 settings) {
        this.settings = settings;
        return this.self();
    }

    public B maxFood(int maxFood) {
        this.maxFood = maxFood;
        return this.self();
    }

    public B isFood(boolean isFood) {
        this.isFood = isFood;
        return this.self();
    }

    public B cItem(@Nullable FoodBlock.EnforceAsItem cItem) {
        this.cItem = cItem;
        return this.self();
    }

    public B useItemTranslationKey(boolean useItemTranslationKey) {
        this.useItemTranslationKey = useItemTranslationKey;
        return this.self();
    }

    public B simpleShape(@Nullable class_265 simpleShape) {
        this.simpleShape = simpleShape;
        return this.self();
    }

    public T build() {
        this.validateSettings();
        this.preCacheIntProperty();
        return this.createBlock();
    }

    protected B self() {
        return (B)this;
    }

    protected abstract T createBlock();

    protected void validateSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings must be provided");
        }
        if (this.maxFood < 1) {
            throw new IllegalStateException("Max food count must be greater than 0");
        }
    }

    protected void preCacheIntProperty() {
        IntPropertyManager.preCache("number_of_food", this.maxFood);
    }
}

