/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9326;
import org.dfood.block.ComplexFoodBlock;
import org.dfood.block.entity.ModBlockEntityTypes;
import org.dfood.util.DFoodUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexFoodBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexFoodBlockEntity.class);
    protected final Stack<class_9326> componentChangesStack = new Stack();
    protected int maxCapacity;

    public ComplexFoodBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.COMPLEX_FOOD, pos, state);
    }

    public ComplexFoodBlockEntity(class_2591<? extends ComplexFoodBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ComplexFoodBlock) {
            ComplexFoodBlock complexFoodBlock = (ComplexFoodBlock)class_22482;
            this.maxCapacity = complexFoodBlock.MAX_FOOD;
        }
    }

    public boolean pushComponentChanges(@Nullable class_9326 componentChanges) {
        if (this.componentChangesStack.size() >= this.maxCapacity) {
            return false;
        }
        if (componentChanges == null) {
            componentChanges = class_9326.field_49588;
        }
        this.componentChangesStack.push(componentChanges);
        this.method_5431();
        return true;
    }

    @Nullable
    public class_9326 popComponentChanges() {
        if (this.componentChangesStack.isEmpty()) {
            return null;
        }
        class_9326 popped = this.componentChangesStack.pop();
        this.method_5431();
        return popped;
    }

    @Nullable
    public class_9326 peekComponentChanges() {
        return this.componentChangesStack.isEmpty() ? null : this.componentChangesStack.peek();
    }

    public int getComponentChangesCount() {
        return this.componentChangesStack.size();
    }

    public boolean isFull() {
        return this.componentChangesStack.size() >= this.maxCapacity;
    }

    public boolean isEmpty() {
        return this.componentChangesStack.isEmpty();
    }

    public void clearComponentChanges() {
        this.componentChangesStack.clear();
        this.method_5431();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 componentChangesList = new class_2499();
        for (class_9326 changes : this.componentChangesStack) {
            DataResult result = class_9326.field_49589.encodeStart((DynamicOps)class_2509.field_11560, (Object)changes);
            result.result().ifPresent(arg_0 -> componentChangesList.add(arg_0));
            result.error().ifPresent(error -> LOGGER.error("Failed to encode ComponentChanges: {}", (Object)error.message()));
        }
        nbt.method_10566("ComponentChangesStack", (class_2520)componentChangesList);
        nbt.method_10569("MaxCapacity", this.maxCapacity);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.componentChangesStack.clear();
        if (nbt.method_10573("ComponentChangesStack", 9)) {
            class_2499 componentChangesList = nbt.method_10554("ComponentChangesStack", 10);
            for (int i = 0; i < componentChangesList.size(); ++i) {
                DataResult result = class_9326.field_49589.parse((DynamicOps)class_2509.field_11560, (Object)componentChangesList.method_10602(i));
                result.result().ifPresent(this.componentChangesStack::push);
                result.error().ifPresent(error -> LOGGER.error("Failed to parse ComponentChanges: {}", (Object)error.message()));
            }
        }
        if (nbt.method_10573("MaxCapacity", 3)) {
            this.maxCapacity = nbt.method_10550("MaxCapacity");
        }
    }

    public List<class_9326> getAllComponentChanges() {
        return new ArrayList<class_9326>(this.componentChangesStack);
    }

    public List<class_1799> getAllStack() {
        int count = DFoodUtils.getFoodBlockCount(this.method_11010());
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(count);
        for (int i = 0; i < count; ++i) {
            class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204().method_8389());
            class_9326 changes = this.getComponentChangesAt(i);
            if (changes != null && !changes.method_57848()) {
                stack.method_57366(changes);
            }
            stacks.add(stack);
        }
        return stacks;
    }

    @Nullable
    public class_9326 getComponentChangesAt(int index) {
        if (index < 0 || index >= this.componentChangesStack.size()) {
            return null;
        }
        return (class_9326)this.componentChangesStack.get(index);
    }
}

