/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dfood.block.FoodBlock;
import org.dfood.block.FoodBlockBuilder;
import org.dfood.block.entity.ComplexFoodBlockEntity;
import org.jetbrains.annotations.Nullable;

public class ComplexFoodBlock
extends FoodBlock
implements EntityBlock {
    protected ComplexFoodBlock(BlockBehaviour.Properties properties, int maxFood, boolean isFood, @Nullable VoxelShape simpleShape, boolean useItemTranslationKey, @Nullable FoodBlock.EnforceAsItem cItem) {
        super(properties, maxFood, isFood, simpleShape, useItemTranslationKey, cItem);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ComplexFoodBlockEntity(pos, state);
    }

    @Override
    public boolean isSame(ItemStack stack, BlockState state, @Nullable BlockEntity blockEntity) {
        return super.isSame(stack, state, blockEntity);
    }

    @Override
    protected boolean tryAdd(BlockState state, Level world, BlockPos pos, Player player, ItemStack handStack, @Nullable BlockEntity blockEntity) {
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            CompoundTag stackNbt = handStack.m_41782_() ? handStack.m_41783_().m_6426_() : new CompoundTag();
            complexFoodBlockEntity.pushNbt(stackNbt);
        }
        return super.tryAdd(state, world, pos, player, handStack, blockEntity);
    }

    @Override
    public ItemStack createStack(int count, BlockState state, @Nullable BlockEntity blockEntity) {
        ComplexFoodBlockEntity complexFoodBlockEntity;
        CompoundTag storedNbt;
        if (count <= 0 || count > this.MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + this.MAX_FOOD);
        }
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_(), count);
        if (blockEntity instanceof ComplexFoodBlockEntity && (storedNbt = (complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity).popNbt()) != null && !storedNbt.m_128456_()) {
            stack.m_41751_(storedNbt);
        }
        return stack;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            CompoundTag stackNbt = itemStack.m_41782_() ? itemStack.m_41783_().m_6426_() : new CompoundTag();
            complexFoodBlockEntity.pushNbt(stackNbt);
            complexFoodBlockEntity.m_6596_();
        }
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        int foodCount = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
        if (foodCount <= 0) {
            return Collections.emptyList();
        }
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < foodCount; ++i) {
                droppedStacks.add(this.createStack(1, state, complexFoodBlockEntity));
            }
            return droppedStacks;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_(), foodCount));
    }

    public static class Builder
    extends FoodBlockBuilder<ComplexFoodBlock, Builder> {
        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        @Override
        protected ComplexFoodBlock createBlock() {
            return new ComplexFoodBlock(this.settings, this.maxFood, this.isFood, this.simpleShape, this.useItemTranslationKey, this.cItem);
        }
    }
}

