/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dfood.block.FoodBlockBuilder;
import org.dfood.item.HaveBlock;
import org.dfood.shape.FoodShapeHandle;
import org.dfood.tag.ModTags;
import org.dfood.util.DFoodUtils;
import org.dfood.util.IntegerPropertyManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodBlock
extends Block {
    private static final Set<FoodBlock> REGISTERED_FOOD_BLOCKS = new HashSet<FoodBlock>();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final FoodShapeHandle SHAPE_HANDLE = FoodShapeHandle.getInstance();
    public final IntegerProperty NUMBER_OF_FOOD;
    public final int MAX_FOOD;
    public final boolean useItemTranslationKey;
    @Nullable
    public final VoxelShape simpleShape;
    @Nullable
    private final EnforceAsItem cItem;
    @Nullable
    protected OnUseHook onUseHook = null;

    protected FoodBlock(BlockBehaviour.Properties settings, int maxFood, boolean isFood, @Nullable VoxelShape simpleShape, boolean useItemTranslationKey, @Nullable EnforceAsItem cItem) {
        super(settings);
        this.MAX_FOOD = maxFood;
        this.NUMBER_OF_FOOD = IntegerPropertyManager.create("number_of_food", this.MAX_FOOD);
        this.cItem = cItem;
        this.simpleShape = simpleShape;
        this.useItemTranslationKey = useItemTranslationKey;
        if (isFood) {
            REGISTERED_FOOD_BLOCKS.add(this);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1)));
    }

    public boolean hasCItem() {
        return this.cItem != null;
    }

    public String m_7705_() {
        if (this.useItemTranslationKey) {
            return "item." + BuiltInRegistries.f_256975_.m_7981_((Object)this).toString().replace(':', '.');
        }
        return super.m_7705_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.simpleShape != null) {
            return this.simpleShape;
        }
        return SHAPE_HANDLE.getShape(state, this.NUMBER_OF_FOOD);
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(1));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult hookResult;
        if (this.onUseHook != null && (hookResult = this.onUseHook.interact(state, world, pos, player, hand, hit)) != InteractionResult.PASS) {
            return hookResult;
        }
        ItemStack handStack = player.m_21120_(hand);
        int currentCount = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
        BlockEntity blockEntity = world.m_7702_(pos);
        boolean isHoldingSameItem = this.isSame(handStack, state, blockEntity);
        if (isHoldingSameItem && currentCount < this.MAX_FOOD && this.tryAdd(state, world, pos, player, handStack, blockEntity)) {
            this.playPlaceSound(world, pos, player);
            this.consumeItemIfNotCreative(player, handStack, hand);
            return InteractionResult.SUCCESS;
        }
        if (currentCount > 0 && this.tryRemove(state, world, pos, player, blockEntity)) {
            this.playTakeSound(world, pos, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean tryAdd(BlockState state, Level world, BlockPos pos, Player player, ItemStack handStack, BlockEntity blockEntity) {
        int currentCount = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
        BlockState newState = (BlockState)state.m_61124_((Property)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(currentCount + 1));
        return world.m_7731_(pos, newState, 3);
    }

    protected boolean consumeItemIfNotCreative(Player player, ItemStack handStack, InteractionHand hand) {
        if (!player.m_7500_() && !handStack.m_41619_()) {
            handStack.m_41774_(1);
            player.m_21008_(hand, handStack);
            return true;
        }
        return false;
    }

    protected boolean tryRemove(BlockState state, Level world, BlockPos pos, Player player, BlockEntity blockEntity) {
        ItemStack foodItem;
        int currentCount = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
        int newCount = currentCount - 1;
        if (newCount > 0) {
            BlockState newState = (BlockState)state.m_61124_((Property)this.NUMBER_OF_FOOD, (Comparable)Integer.valueOf(newCount));
            world.m_7731_(pos, newState, 3);
        } else {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        if (!player.m_7500_() && !player.m_36356_(foodItem = this.createStack(1, state, blockEntity))) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)foodItem);
        }
        return true;
    }

    public boolean isSame(ItemStack stack, BlockState state, BlockEntity blockEntity) {
        return stack.m_41720_() == this.m_5456_();
    }

    public ItemStack createStack(int count, BlockState state, @Nullable BlockEntity blockEntity) {
        if (count <= 0 || count > this.MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + this.MAX_FOOD);
        }
        return new ItemStack((ItemLike)this.m_5456_(), count);
    }

    public void playPlaceSound(Level world, BlockPos pos, Player player) {
        world.m_5594_(player, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public void playTakeSound(Level world, BlockPos pos, Player player) {
        world.m_5594_(player, pos, this.f_60446_.m_56775_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    @Nullable
    public OnUseHook getOnUseHook() {
        return this.onUseHook;
    }

    public void setOnUseHook(@Nullable OnUseHook onUseHook) {
        this.onUseHook = onUseHook;
    }

    public static Set<FoodBlock> getRegisteredFoodBlocks() {
        return Collections.unmodifiableSet(REGISTERED_FOOD_BLOCKS);
    }

    public boolean haveCItem() {
        return this.cItem != null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos downPos = pos.m_7495_();
        BlockState checkState = world.m_8055_(downPos);
        return !checkState.m_204336_(ModTags.FOOD_PLACE) && !DFoodUtils.isModFoodBlock(checkState.m_60734_());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        int foodCount = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
        if (foodCount <= 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_(), foodCount));
    }

    @NotNull
    public Item m_5456_() {
        if (this.cItem != null) {
            return this.cItem.getItem();
        }
        return super.m_5456_() == Items.f_41852_ ? HaveBlock.byBlock(this) : super.m_5456_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{IntegerPropertyManager.take()});
    }

    @FunctionalInterface
    public static interface OnUseHook {
        public InteractionResult interact(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6);
    }

    public static interface EnforceAsItem {
        public Item getItem();
    }

    public static class Builder
    extends FoodBlockBuilder<FoodBlock, Builder> {
        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        @Override
        protected FoodBlock createBlock() {
            return new FoodBlock(this.settings, this.maxFood, this.isFood, this.simpleShape, this.useItemTranslationKey, this.cItem);
        }
    }
}

