/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dfood.block.FoodBlock;
import org.dfood.util.IntegerPropertyManager;
import org.jetbrains.annotations.Nullable;

public abstract class FoodBlockBuilder<T extends FoodBlock, B extends FoodBlockBuilder<T, B>> {
    protected BlockBehaviour.Properties settings;
    protected int maxFood = 1;
    protected boolean isFood = true;
    @Nullable
    protected FoodBlock.EnforceAsItem cItem = null;
    protected boolean useItemTranslationKey = true;
    @Nullable
    protected VoxelShape simpleShape = null;

    protected FoodBlockBuilder() {
    }

    public B settings(BlockBehaviour.Properties settings) {
        this.settings = settings;
        return this.self();
    }

    public B maxFood(int maxFood) {
        this.maxFood = maxFood;
        return this.self();
    }

    public B isFood(boolean isFood) {
        this.isFood = isFood;
        return this.self();
    }

    public B cItem(@Nullable FoodBlock.EnforceAsItem cItem) {
        this.cItem = cItem;
        return this.self();
    }

    public B useItemTranslationKey(boolean useItemTranslationKey) {
        this.useItemTranslationKey = useItemTranslationKey;
        return this.self();
    }

    public B simpleShape(@Nullable VoxelShape simpleShape) {
        this.simpleShape = simpleShape;
        return this.self();
    }

    public T build() {
        this.validateSettings();
        this.preCacheIntProperty();
        return this.createBlock();
    }

    protected B self() {
        return (B)this;
    }

    protected abstract T createBlock();

    protected void validateSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings must be provided");
        }
        if (this.maxFood < 1) {
            throw new IllegalStateException("Max food count must be greater than 0");
        }
    }

    protected void preCacheIntProperty() {
        IntegerPropertyManager.preCache("number_of_food", this.maxFood);
    }
}

