/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.dfood.block.ChorusFruitBlock;
import org.dfood.block.EnchantedGoldenAppleBlock;
import org.dfood.block.EnforceAsItems;
import org.dfood.block.FoodBlock;
import org.dfood.block.ModTotemBlock;
import org.dfood.block.PotionBlock;
import org.dfood.block.SuspiciousStewBlock;
import org.dfood.sound.ModSoundGroups;
import org.dfood.util.DFoodUtils;
import org.dfood.util.IntegerPropertyManager;

public class FoodBlocks {
    public static final Map<String, Block> FOOD_BLOCK_REGISTRY = new HashMap<String, Block>();
    public static final Block COOKIE = FoodBlocks.registerFoodBlock("cookie", 10, MapColor.f_283843_, SoundType.f_56742_);
    public static final Block APPLE = FoodBlocks.registerFoodBlock("apple", 5, MapColor.f_283913_, SoundType.f_56742_);
    public static final Block MELON_SLICE = FoodBlocks.registerFoodBlock("melon_slice", 5, MapColor.f_283916_, SoundType.f_56742_);
    public static final Block BREAD = FoodBlocks.registerFoodBlock("bread", 5, MapColor.f_283843_, ModSoundGroups.BREAD);
    public static final Block BEETROOT = FoodBlocks.registerFoodBlock("beetroot", 5, MapColor.f_283913_, SoundType.f_154653_);
    public static final Block POTATO = FoodBlocks.registerFoodBlock("potato", 5, MapColor.f_283757_, SoundType.f_154653_, EnforceAsItems.POTATO);
    public static final Block BAKED_POTATO = FoodBlocks.registerFoodBlock("baked_potato", 5, MapColor.f_283757_, SoundType.f_154653_);
    public static final Block CARROT = FoodBlocks.registerFoodBlock("carrot", 5, MapColor.f_283832_, SoundType.f_154653_, EnforceAsItems.CARROT);
    public static final Block SWEET_BERRIES = FoodBlocks.registerFoodBlock("sweet_berries", 5, MapColor.f_283913_, SoundType.f_56757_, EnforceAsItems.SWEET_BERRIES);
    public static final Block GLOW_BERRIES = FoodBlocks.registerFoodBlock("glow_berries", ((FoodBlock.Builder)((FoodBlock.Builder)((FoodBlock.Builder)FoodBlock.Builder.create().maxFood(12)).cItem(EnforceAsItems.GLOW_BERRIES)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283832_).m_60918_(SoundType.f_56757_).m_60953_(state -> state.m_60734_() instanceof FoodBlock ? (Integer)state.m_61143_((Property)IntegerPropertyManager.create("number_of_food", 12)) + 3 : 0))).build());
    public static final Block GOLDEN_APPLE = FoodBlocks.registerFoodBlock("golden_apple", 5, MapColor.f_283757_, null);
    public static final Block GOLDEN_CARROT = FoodBlocks.registerFoodBlock("golden_carrot", 5, MapColor.f_283757_, SoundType.f_154653_);
    public static final Block GLISTERING_MELON_SLICE = FoodBlocks.registerFoodBlock("glistering_melon_slice", 5, MapColor.f_283757_, null);
    public static final Block ENCHANTED_GOLDEN_APPLE = FoodBlocks.registerFoodBlock("enchanted_golden_apple", ((EnchantedGoldenAppleBlock.Builder)((EnchantedGoldenAppleBlock.Builder)EnchantedGoldenAppleBlock.Builder.create().maxFood(5)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283757_))).build());
    public static final Block CHICKEN = FoodBlocks.registerFoodBlock("chicken", 1, MapColor.f_283779_, ModSoundGroups.MEAT);
    public static final Block COOKED_CHICKEN = FoodBlocks.registerFoodBlock("cooked_chicken", 1, MapColor.f_283843_, ModSoundGroups.MEAT);
    public static final Block BEEF = FoodBlocks.registerFoodBlock("beef", 3, MapColor.f_283748_, ModSoundGroups.MEAT);
    public static final Block COOKED_BEEF = FoodBlocks.registerFoodBlock("cooked_beef", 3, MapColor.f_283774_, ModSoundGroups.MEAT);
    public static final Block MUTTON = FoodBlocks.registerFoodBlock("mutton", 3, MapColor.f_283765_, ModSoundGroups.MEAT);
    public static final Block COOKED_MUTTON = FoodBlocks.registerFoodBlock("cooked_mutton", 3, MapColor.f_283870_, ModSoundGroups.MEAT);
    public static final Block PORKCHOP = FoodBlocks.registerFoodBlock("porkchop", 3, MapColor.f_283765_, ModSoundGroups.MEAT);
    public static final Block COOKED_PORKCHOP = FoodBlocks.registerFoodBlock("cooked_porkchop", 3, MapColor.f_283870_, ModSoundGroups.MEAT);
    public static final Block RABBIT = FoodBlocks.registerFoodBlock("rabbit", 1, MapColor.f_283748_, ModSoundGroups.MEAT);
    public static final Block COOKED_RABBIT = FoodBlocks.registerFoodBlock("cooked_rabbit", 1, MapColor.f_283774_, ModSoundGroups.MEAT);
    public static final Block COD = FoodBlocks.registerFoodBlock("cod", 3, MapColor.f_283869_, ModSoundGroups.FISH);
    public static final Block COOKED_COD = FoodBlocks.registerFoodBlock("cooked_cod", 3, MapColor.f_283791_, ModSoundGroups.FISH);
    public static final Block SALMON = FoodBlocks.registerFoodBlock("salmon", 3, MapColor.f_283869_, ModSoundGroups.FISH);
    public static final Block COOKED_SALMON = FoodBlocks.registerFoodBlock("cooked_salmon", 3, MapColor.f_283791_, ModSoundGroups.FISH);
    public static final Block PUFFERFISH = FoodBlocks.registerFoodBlock("pufferfish", 1, MapColor.f_283869_, ModSoundGroups.FISH);
    public static final Block TROPICAL_FISH = FoodBlocks.registerFoodBlock("tropical_fish", 4, MapColor.f_283913_, ModSoundGroups.FISH);
    public static final Block RABBIT_STEW = FoodBlocks.registerFoodBlock("rabbit_stew", 1, MapColor.f_283748_, SoundType.f_271215_);
    public static final Block MUSHROOM_STEW = FoodBlocks.registerFoodBlock("mushroom_stew", 1, MapColor.f_283748_, SoundType.f_271215_);
    public static final Block BEETROOT_SOUP = FoodBlocks.registerFoodBlock("beetroot_soup", 1, MapColor.f_283748_, SoundType.f_271215_);
    public static final Block SUSPICIOUS_STEW = FoodBlocks.registerFoodBlock("suspicious_stew", ((SuspiciousStewBlock.Builder)((SuspiciousStewBlock.Builder)SuspiciousStewBlock.Builder.create().maxFood(1)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283748_).m_60918_(SoundType.f_271215_))).build());
    public static final Block BOWL = FoodBlocks.registerFoodBlock("bowl", 1, MapColor.f_283748_, SoundType.f_271215_);
    public static final Block BUCKET = FoodBlocks.registerFoodBlock("bucket", 1, MapColor.f_283811_, ModSoundGroups.BUCKET, EnforceAsItems.BUCKET);
    public static final Block WATER_BUCKET = FoodBlocks.registerFoodBlock("water_bucket", 1, MapColor.f_283743_, ModSoundGroups.WATER_BUCKET, EnforceAsItems.WATER_BUCKET);
    public static final Block MILK_BUCKET = FoodBlocks.registerFoodBlock("milk_bucket", 1, MapColor.f_283811_, ModSoundGroups.WATER_BUCKET);
    public static final Block LAVA_BUCKET = FoodBlocks.registerFoodBlock("lava_bucket", ((FoodBlock.Builder)((FoodBlock.Builder)((FoodBlock.Builder)FoodBlock.Builder.create().maxFood(1)).settings(DFoodUtils.getFoodBlockSettings().m_60918_(ModSoundGroups.LAVA_BUCKET).m_284180_(MapColor.f_283750_).m_60953_(state -> 15))).cItem(EnforceAsItems.LAVA_BUCKET)).build());
    public static final Block PUMPKIN_PIE = FoodBlocks.registerFoodBlock("pumpkin_pie", 1, MapColor.f_283895_, SoundType.f_56745_);
    public static final Block CHORUS_FRUIT = FoodBlocks.registerFoodBlock("chorus_fruit", ((ChorusFruitBlock.Builder)((ChorusFruitBlock.Builder)ChorusFruitBlock.Builder.create().maxFood(5)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283889_).m_60918_(ModSoundGroups.CHORUS_FRUIT))).build());
    public static final Block EGG = FoodBlocks.registerFoodBlock("egg", 5, MapColor.f_283811_, ModSoundGroups.EGG);
    public static final Block TOTEM_OF_UNDYING = FoodBlocks.registerFoodBlock("totem_of_undying", new ModTotemBlock(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283832_).m_60918_(ModSoundGroups.EGG)));
    public static final Block POTION = FoodBlocks.registerFoodBlock("potion", ((PotionBlock.Builder)((PotionBlock.Builder)PotionBlock.Builder.create().maxFood(3)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(MapColor.f_283889_).m_60918_(ModSoundGroups.POTION))).build());
    public static final Block GLASS_BOTTLE = FoodBlocks.registerFoodBlock("glass_bottle", 3, MapColor.f_283811_, ModSoundGroups.GLASS_BOTTLE);
    public static final Block HONEY_BOTTLE = FoodBlocks.registerFoodBlock("honey_bottle", 3, MapColor.f_283750_, ModSoundGroups.POTION);

    private static Block registerFoodBlock(String id, Block block) {
        FOOD_BLOCK_REGISTRY.put(id, block);
        return block;
    }

    private static Block registerFoodBlock(String id, int maxFood, BlockBehaviour.Properties settings) {
        Object block = ((FoodBlock.Builder)((FoodBlock.Builder)FoodBlock.Builder.create().maxFood(maxFood)).settings(settings)).build();
        return FoodBlocks.registerFoodBlock(id, block);
    }

    private static Block registerFoodBlock(String id, int maxFood, MapColor mapColor, SoundType sound) {
        return FoodBlocks.registerFoodBlock(id, maxFood, mapColor, sound, null);
    }

    private static Block registerFoodBlock(String id, int maxFood, MapColor mapColor, SoundType sound, FoodBlock.EnforceAsItem cropType) {
        SoundType finalSound = sound == null ? SoundType.f_56742_ : sound;
        Object block = ((FoodBlock.Builder)((FoodBlock.Builder)((FoodBlock.Builder)FoodBlock.Builder.create().maxFood(maxFood)).cItem(cropType)).settings(DFoodUtils.getFoodBlockSettings().m_284180_(mapColor).m_60918_(finalSound))).build();
        return FoodBlocks.registerFoodBlock(id, block);
    }
}

