/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.dfood.block.FoodBlock;
import org.dfood.block.FoodBlockBuilder;
import org.dfood.block.entity.SuspiciousStewBlockEntity;
import org.jetbrains.annotations.Nullable;

public class SuspiciousStewBlock
extends FoodBlock
implements EntityBlock {
    protected SuspiciousStewBlock(BlockBehaviour.Properties properties, int maxFood) {
        super(properties, maxFood, true, null, true, null);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SuspiciousStewBlockEntity(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof SuspiciousStewBlockEntity) {
            SuspiciousStewBlockEntity suspiciousStewBlockEntity = (SuspiciousStewBlockEntity)blockEntity;
            CompoundTag stackNbt = itemStack.m_41783_();
            if (stackNbt != null) {
                suspiciousStewBlockEntity.readCustomDataFromItem(stackNbt);
            }
        }
    }

    @Override
    public boolean isSame(ItemStack stack, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof SuspiciousStewBlockEntity) {
            SuspiciousStewBlockEntity suspiciousStewBlockEntity = (SuspiciousStewBlockEntity)blockEntity;
            if (super.isSame(stack, state, blockEntity)) {
                CompoundTag stewStackNbt = suspiciousStewBlockEntity.getStewStack().m_41783_();
                CompoundTag stackNbt = stack.m_41783_();
                if (stackNbt != null && stewStackNbt != null && stackNbt.m_128441_("Effects") && stewStackNbt.m_128441_("Effects")) {
                    return Objects.equals(stewStackNbt.m_128423_("Effects"), stackNbt.m_128423_("Effects"));
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public ItemStack createStack(int count, BlockState state, @Nullable BlockEntity blockEntity) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42718_, count);
        if (blockEntity instanceof SuspiciousStewBlockEntity) {
            SuspiciousStewBlockEntity suspiciousStewBlockEntity = (SuspiciousStewBlockEntity)blockEntity;
            CompoundTag nbt = stack.m_41784_();
            suspiciousStewBlockEntity.writeCustomDataToItem(nbt);
        }
        return stack;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof SuspiciousStewBlockEntity) {
            SuspiciousStewBlockEntity suspiciousStewBlockEntity = (SuspiciousStewBlockEntity)blockEntity;
            int count = (Integer)state.m_61143_((Property)this.NUMBER_OF_FOOD);
            ItemStack baseStack = suspiciousStewBlockEntity.getStewStack();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                drops.add(baseStack.m_41777_());
            }
            return drops;
        }
        return List.of();
    }

    public static class Builder
    extends FoodBlockBuilder<SuspiciousStewBlock, Builder> {
        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        @Override
        protected SuspiciousStewBlock createBlock() {
            return new SuspiciousStewBlock(this.settings, this.maxFood);
        }
    }
}

