/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.dfood.block.ComplexFoodBlock;
import org.dfood.block.entity.ModBlockEntityTypes;
import org.dfood.util.DFoodUtils;
import org.jetbrains.annotations.Nullable;

public class ComplexFoodBlockEntity
extends BlockEntity {
    protected final Stack<CompoundTag> nbtStack = new Stack();
    protected int maxCapacity;

    public ComplexFoodBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ComplexFoodBlockEntity>)((BlockEntityType)ModBlockEntityTypes.COMPLEX_FOOD.get()), pos, state);
    }

    public ComplexFoodBlockEntity(BlockEntityType<? extends ComplexFoodBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Block block = state.m_60734_();
        if (block instanceof ComplexFoodBlock) {
            ComplexFoodBlock complexFoodBlock = (ComplexFoodBlock)block;
            this.maxCapacity = complexFoodBlock.MAX_FOOD;
        }
    }

    public boolean pushNbt(@Nullable CompoundTag nbt) {
        if (this.nbtStack.size() >= this.maxCapacity) {
            return false;
        }
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        this.nbtStack.push(nbt);
        this.m_6596_();
        return true;
    }

    @Nullable
    public CompoundTag popNbt() {
        if (this.nbtStack.isEmpty()) {
            return null;
        }
        CompoundTag popped = this.nbtStack.pop();
        this.m_6596_();
        return popped;
    }

    @Nullable
    public CompoundTag peekNbt() {
        return this.nbtStack.isEmpty() ? null : this.nbtStack.peek();
    }

    public int getNbtCount() {
        return this.nbtStack.size();
    }

    public boolean isFull() {
        return this.nbtStack.size() >= this.maxCapacity;
    }

    public boolean isEmpty() {
        return this.nbtStack.isEmpty();
    }

    public void clearNbt() {
        this.nbtStack.clear();
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ListTag nbtList = new ListTag();
        nbtList.addAll(this.nbtStack);
        nbt.m_128365_("NbtStack", (Tag)nbtList);
        nbt.m_128405_("MaxCapacity", this.maxCapacity);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.nbtStack.clear();
        if (nbt.m_128425_("NbtStack", 9)) {
            ListTag nbtList = nbt.m_128437_("NbtStack", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                this.nbtStack.push(nbtList.m_128728_(i));
            }
        }
        if (nbt.m_128425_("MaxCapacity", 3)) {
            this.maxCapacity = nbt.m_128451_("MaxCapacity");
        }
    }

    public List<CompoundTag> getAllNbt() {
        return new ArrayList<CompoundTag>(this.nbtStack);
    }

    public List<ItemStack> getAllStack() {
        int count = DFoodUtils.getFoodBlockCount(this.m_58900_());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(count);
        for (int i = 0; i < count; ++i) {
            ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_());
            stack.m_41751_(this.getNbtAt(i));
            stacks.add(stack);
        }
        return stacks;
    }

    @Nullable
    public CompoundTag getNbtAt(int index) {
        if (index < 0 || index >= this.nbtStack.size()) {
            return null;
        }
        return (CompoundTag)this.nbtStack.get(index);
    }
}

