/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.dfood.block.entity.ComplexFoodBlockEntity;
import org.dfood.block.entity.ModBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class PotionBlockEntity
extends ComplexFoodBlockEntity {
    public PotionBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends ComplexFoodBlockEntity>)((BlockEntityType)ModBlockEntityTypes.POTION_BLOCK_ENTITY.get()), pos, state);
    }

    @Nullable
    public Potion getPotionAtIndex(int index) {
        CompoundTag nbt = this.getNbtAt(index);
        return nbt != null ? this.getPotionFromNbt(nbt) : null;
    }

    private Potion getPotionFromNbt(CompoundTag nbt) {
        if (nbt.m_128441_("Potion")) {
            return Potion.m_43489_((String)nbt.m_128461_("Potion"));
        }
        return Potions.f_43598_;
    }

    public int getColor(int index) {
        CompoundTag nbt = this.getNbtAt(index);
        if (nbt != null && !nbt.m_128456_()) {
            Potion potion = this.getPotionFromNbt(nbt);
            return potion != null ? PotionUtils.m_43559_((Potion)potion) : 0xF800F8;
        }
        return 0xF800F8;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

