/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.dfood.block.entity.ModBlockEntityTypes;

public class SuspiciousStewBlockEntity
extends BlockEntity {
    protected final Map<Integer, Integer> EffectMap = new HashMap<Integer, Integer>();

    public SuspiciousStewBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SuspiciousStewBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntityTypes.SUSPICIOUS_STEW_BLOCK_ENTITY.get(), pos, state);
    }

    private void readEffectsFromNbt(CompoundTag nbt) {
        this.EffectMap.clear();
        if (nbt != null && nbt.m_128425_("Effects", 9)) {
            ListTag effectsList = nbt.m_128437_("Effects", 10);
            for (int i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectTag = effectsList.m_128728_(i);
                if (!effectTag.m_128425_("EffectId", 99)) continue;
                int effectId = effectTag.m_128451_("EffectId");
                int duration = effectTag.m_128425_("EffectDuration", 99) ? effectTag.m_128451_("EffectDuration") : 160;
                this.EffectMap.put(effectId, duration);
            }
        }
    }

    public void readCustomDataFromItem(CompoundTag nbt) {
        this.readEffectsFromNbt(nbt);
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.readEffectsFromNbt(nbt);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeCustomDataToItem(nbt);
    }

    public void writeCustomDataToItem(CompoundTag nbt) {
        if (!this.EffectMap.isEmpty()) {
            ListTag effectsList = new ListTag();
            for (Map.Entry<Integer, Integer> entry : this.EffectMap.entrySet()) {
                CompoundTag effectTag = new CompoundTag();
                effectTag.m_128405_("EffectId", entry.getKey().intValue());
                effectTag.m_128405_("EffectDuration", entry.getValue().intValue());
                effectsList.add((Object)effectTag);
            }
            nbt.m_128365_("Effects", (Tag)effectsList);
        }
    }

    public ItemStack getStewStack() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42718_);
        this.writeCustomDataToItem(stack.m_41784_());
        return stack;
    }

    public Map<Integer, Integer> getEffectMap() {
        return new HashMap<Integer, Integer>(this.EffectMap);
    }

    public void addEffect(int effectId, int duration) {
        this.EffectMap.put(effectId, duration);
        this.m_6596_();
    }

    public void clearEffects() {
        this.EffectMap.clear();
        this.m_6596_();
    }
}

