/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.item;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;

public interface HaveBlock {
    public static final Map<Block, Item> BY_BLOCK = Maps.newHashMap();

    public Block getBlock();

    default public void appendBlocks(Map<Block, Item> map, Item item) {
        map.put(this.getBlock(), item);
        BY_BLOCK.put(this.getBlock(), item);
    }

    public static Item byBlock(Block block) {
        if (BY_BLOCK.containsKey(block)) {
            return BY_BLOCK.get(block);
        }
        return Items.f_41852_;
    }

    default public InteractionResult place(BlockPlaceContext context) {
        if (!this.getBlock().m_245993_(context.m_43725_().m_246046_())) {
            return InteractionResult.FAIL;
        }
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext itemPlacementContext = this.getPlacementContext(context);
        if (itemPlacementContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(itemPlacementContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.place(itemPlacementContext, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = itemPlacementContext.m_8083_();
        Level world = itemPlacementContext.m_43725_();
        Player playerEntity = itemPlacementContext.m_43723_();
        ItemStack itemStack = itemPlacementContext.m_43722_();
        BlockState blockState2 = world.m_8055_(blockPos);
        if (blockState2.m_60713_(blockState.m_60734_())) {
            blockState2 = this.placeFromNbt(blockPos, world, itemStack, blockState2);
            this.postPlacement(blockPos, world, playerEntity, itemStack, blockState2);
            blockState2.m_60734_().m_6402_(world, blockPos, blockState2, (LivingEntity)playerEntity, itemStack);
            if (playerEntity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)playerEntity, blockPos, itemStack);
            }
        }
        SoundType blockSoundGroup = blockState2.m_60827_();
        world.m_5594_(playerEntity, blockPos, this.getPlaceSound(blockState2), SoundSource.BLOCKS, (blockSoundGroup.m_56773_() + 1.0f) / 2.0f, blockSoundGroup.m_56774_() * 0.8f);
        world.m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)playerEntity, (BlockState)blockState2));
        if (playerEntity == null || !playerEntity.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Nullable
    default public BlockState getPlacementState(BlockPlaceContext context) {
        BlockState blockState = this.getBlock().m_5573_(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    default public SoundEvent getPlaceSound(BlockState state) {
        return state.m_60827_().m_56777_();
    }

    @Nullable
    default public BlockPlaceContext getPlacementContext(BlockPlaceContext context) {
        return context;
    }

    default public boolean postPlacement(BlockPos pos, Level world, @Nullable Player player, ItemStack stack, BlockState state) {
        return HaveBlock.writeNbtToBlockEntity(world, player, pos, stack);
    }

    private BlockState placeFromNbt(BlockPos pos, Level world, ItemStack stack, BlockState state) {
        BlockState blockState = state;
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound != null) {
            CompoundTag nbtCompound2 = nbtCompound.m_128469_("BlockStateTag");
            StateDefinition stateManager = state.m_60734_().m_49965_();
            for (String string : nbtCompound2.m_128431_()) {
                Property property = stateManager.m_61081_(string);
                if (property == null) continue;
                String string2 = Objects.requireNonNull(nbtCompound2.m_128423_(string)).m_7916_();
                blockState = HaveBlock.with(blockState, property, string2);
            }
        }
        if (blockState != state) {
            world.m_7731_(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState with(BlockState state, Property<T> property, String name) {
        return property.m_6215_(name).map(value -> (BlockState)state.m_61124_(property, value)).orElse(state);
    }

    default public boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player playerEntity = context.m_43723_();
        CollisionContext shapeContext = playerEntity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerEntity);
        return (!this.checkStatePlacement() || state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) && context.m_43725_().m_45752_(state, context.m_8083_(), shapeContext);
    }

    default public boolean checkStatePlacement() {
        return true;
    }

    public static boolean writeNbtToBlockEntity(Level world, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity;
        CompoundTag nbtCompound;
        MinecraftServer minecraftServer = world.m_7654_();
        if (minecraftServer != null && (nbtCompound = HaveBlock.getBlockEntityNbt(stack)) != null && (blockEntity = world.m_7702_(pos)) != null) {
            if (!(world.f_46443_ || !blockEntity.m_6326_() || player != null && player.m_36337_())) {
                return false;
            }
            CompoundTag nbtCompound2 = blockEntity.m_187480_();
            CompoundTag nbtCompound3 = nbtCompound2.m_6426_();
            nbtCompound2.m_128391_(nbtCompound);
            if (!nbtCompound2.equals((Object)nbtCompound3)) {
                blockEntity.m_142466_(nbtCompound2);
                blockEntity.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static CompoundTag getBlockEntityNbt(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag");
    }

    default public boolean place(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }
}

