/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.dfood.block.FoodBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class BucketMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void placeBucket(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Item self = (Item)this;
        if (context.m_43723_() != null && self instanceof BucketItem) {
            Fluid fluid;
            InteractionResult result;
            BucketItem bucketItem = (BucketItem)self;
            if (context.m_43723_().m_6144_() && (result = this.dFood$placeBucketBlock(context, fluid = bucketItem.getFluid())).m_146666_()) {
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }

    @Unique
    private InteractionResult dFood$placeBucketBlock(UseOnContext context, Fluid fluid) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockState = this.dFood$getBucketBlockStateForFluid(fluid, new BlockPlaceContext(context));
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        BlockPos placementPos = pos;
        if (!level.m_8055_(pos).m_247087_()) {
            placementPos = pos.m_121945_(context.m_43719_());
        }
        if (!level.m_8055_(placementPos).m_247087_()) {
            return InteractionResult.FAIL;
        }
        if (!level.m_7731_(placementPos, blockState, 11)) {
            return InteractionResult.FAIL;
        }
        level.m_220407_(GameEvent.f_157797_, placementPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
        SoundType soundType = blockState.m_60827_();
        level.m_5594_(player, placementPos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        if (player != null && !player.m_7500_()) {
            ItemStack heldItem = context.m_43722_();
            heldItem.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Unique
    private BlockState dFood$getBucketBlockStateForFluid(Fluid fluid, BlockPlaceContext context) {
        if (fluid == Fluids.f_76193_) {
            return FoodBlocks.WATER_BUCKET.m_5573_(context);
        }
        if (fluid == Fluids.f_76195_) {
            return FoodBlocks.LAVA_BUCKET.m_5573_(context);
        }
        if (fluid == Fluids.f_76191_) {
            return FoodBlocks.BUCKET.m_5573_(context);
        }
        return null;
    }
}

