/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.mixin;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.dfood.util.DFoodUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerInteractionManagerMixin {
    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void interactBlockMixin(ServerPlayer player, Level level, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos blockPos = hitResult.m_82425_();
        BlockState blockState = level.m_8055_(blockPos);
        boolean isModFoodBlock = DFoodUtils.isModFoodBlock(blockState.m_60734_());
        if (isModFoodBlock && player.m_6144_()) {
            InteractionResult actionResult = blockState.m_60664_(level, (Player)player, hand, hitResult);
            ItemStack itemStack = stack.m_41777_();
            if (actionResult.m_19077_()) {
                CriteriaTriggers.f_10562_.m_285767_(player, blockPos, itemStack);
                cir.setReturnValue((Object)actionResult);
            }
        }
    }
}

