/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.shape;

import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dfood.ThreedFood;
import org.dfood.shape.Shapes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FoodShapeHandle {
    private static final Logger LOGGER = ThreedFood.LOGGER;
    private static final Map<String, int[][]> shapeMap = Shapes.shapeMap;
    private static final FoodShapeHandle INSTANCE = new FoodShapeHandle();

    private FoodShapeHandle() {
    }

    public static FoodShapeHandle getInstance() {
        return INSTANCE;
    }

    public <T extends Enum<T>> VoxelShape getShape(@NotNull BlockState state, IntegerProperty number, Class<T> shapeEnum) {
        String blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
        if (shapeMap.containsKey(blockId)) {
            for (int[] sha : shapeMap.get(blockId)) {
                int i = (Integer)state.m_61143_((Property)number);
                if (i < sha[0] || i > sha[1]) continue;
                return this.getShapeById(sha[2], shapeEnum);
            }
        }
        return this.getDefaultShape(shapeEnum);
    }

    public VoxelShape getShape(BlockState state, IntegerProperty number) {
        return this.getShape(state, number, shapes.class);
    }

    private <T extends Enum<T>> VoxelShape getShapeById(int id, Class<T> shapeEnum) {
        try {
            Enum[] enumConstants;
            for (Enum shape : enumConstants = (Enum[])shapeEnum.getEnumConstants()) {
                if (((ShapeConvertible)((Object)shape)).getId() != id) continue;
                return ((ShapeConvertible)((Object)shape)).getShape();
            }
            LOGGER.warn("No shape definition with ID {} was found, using the default shape", (Object)id);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred when getting a shape based on ID\uff0cID: {}", (Object)id, (Object)e);
        }
        return this.getDefaultShape(shapeEnum);
    }

    private <T extends Enum<T>> VoxelShape getDefaultShape(Class<T> shapeEnum) {
        try {
            Enum[] enumConstants = (Enum[])shapeEnum.getEnumConstants();
            if (enumConstants.length > 0) {
                return ((ShapeConvertible)((Object)enumConstants[0])).getShape();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting the default shape", (Throwable)e);
        }
        LOGGER.warn("Unable to get a default shape from an enum class, use an alternate default shape");
        return shapes.ALL.getShape();
    }

    public static enum shapes implements ShapeConvertible
    {
        ALL(1, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)),
        HALF(2, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)),
        DOUBLE_HALF(3, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)),
        FLAT(4, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)),
        FLAT_SMAIL(5, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0)),
        FLAT_ZH(6, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)),
        ALL_SMAIL(7, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0)),
        ALL_ZH(8, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0)),
        DOUBLE_HEAL_SMAIL(9, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0)),
        DOUBLE_HEAL_ZH(10, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)),
        HALF_SMAIL(11, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0)),
        HALF_ZH(12, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0));

        private final VoxelShape shape;
        private final int id;

        private shapes(int id, VoxelShape shape) {
            this.shape = shape;
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public VoxelShape getShape() {
            return this.shape;
        }

        public static VoxelShape getShape(int id) {
            for (shapes s : shapes.values()) {
                if (s.id != id) continue;
                return s.shape;
            }
            return shapes.ALL.shape;
        }
    }

    public static interface ShapeConvertible {
        public int getId();

        public VoxelShape getShape();
    }
}

