/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.dfood.block.FoodBlocks;
import org.dfood.item.DoubleBlockItem;
import org.dfood.item.ModChorusFruitItem;
import org.dfood.item.ModEggItem;
import org.dfood.item.ModEnchantedGoldenAppleItem;
import org.dfood.item.ModGlassBottleItem;
import org.dfood.item.ModHoneyBottleItem;
import org.dfood.item.ModMilkBucketItem;
import org.dfood.item.ModPotionItem;
import org.dfood.item.ModStewItem;
import org.dfood.item.ModSuspiciousStewItem;

public class FoodToBlocks {
    public static final Map<String, Item> FOOD_MAP = new HashMap<String, Item>();

    public static BlockItem createItem(Block foodBlock, FoodProperties foodComponent) {
        return new BlockItem(foodBlock, new Item.Properties().m_41489_(foodComponent));
    }

    public static Item getItem(String id) {
        Item result = FOOD_MAP.get(id);
        if (result == null) {
            return FoodToBlocks.createDelayedItem(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Item createDelayedItem(String id) {
        Map<String, Item> map = FOOD_MAP;
        synchronized (map) {
            Object item = FOOD_MAP.get(id);
            if (item != null) {
                return item;
            }
            switch (id) {
                case "milk_bucket": {
                    item = new ModMilkBucketItem(new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1), FoodBlocks.MILK_BUCKET);
                    break;
                }
                case "honey_bottle": {
                    item = new ModHoneyBottleItem(FoodBlocks.HONEY_BOTTLE, new Item.Properties().m_41495_(Items.f_42590_).m_41489_(Foods.f_38832_).m_41487_(16));
                    break;
                }
                default: {
                    return null;
                }
            }
            FOOD_MAP.put(id, (Item)item);
            return item;
        }
    }

    static {
        FOOD_MAP.put("cookie", (Item)FoodToBlocks.createItem(FoodBlocks.COOKIE, Foods.f_38827_));
        FOOD_MAP.put("apple", (Item)FoodToBlocks.createItem(FoodBlocks.APPLE, Foods.f_38810_));
        FOOD_MAP.put("melon_slice", (Item)FoodToBlocks.createItem(FoodBlocks.MELON_SLICE, Foods.f_38833_));
        FOOD_MAP.put("bread", (Item)FoodToBlocks.createItem(FoodBlocks.BREAD, Foods.f_38815_));
        FOOD_MAP.put("beetroot", (Item)FoodToBlocks.createItem(FoodBlocks.BEETROOT, Foods.f_38813_));
        FOOD_MAP.put("potato", (Item)new DoubleBlockItem(Blocks.f_50250_, new Item.Properties().m_41489_(Foods.f_38799_), FoodBlocks.POTATO));
        FOOD_MAP.put("baked_potato", (Item)FoodToBlocks.createItem(FoodBlocks.BAKED_POTATO, Foods.f_38811_));
        FOOD_MAP.put("carrot", (Item)new DoubleBlockItem(Blocks.f_50249_, new Item.Properties().m_41489_(Foods.f_38816_), FoodBlocks.CARROT));
        FOOD_MAP.put("sweet_berries", (Item)new DoubleBlockItem(Blocks.f_50685_, new Item.Properties().m_41489_(Foods.f_38808_), FoodBlocks.SWEET_BERRIES));
        FOOD_MAP.put("glow_berries", (Item)new DoubleBlockItem(Blocks.f_152538_, new Item.Properties().m_41489_(Foods.f_150381_), FoodBlocks.GLOW_BERRIES));
        FOOD_MAP.put("golden_apple", (Item)FoodToBlocks.createItem(FoodBlocks.GOLDEN_APPLE, Foods.f_38830_));
        FOOD_MAP.put("golden_carrot", (Item)FoodToBlocks.createItem(FoodBlocks.GOLDEN_CARROT, Foods.f_38831_));
        FOOD_MAP.put("glistering_melon_slice", (Item)new BlockItem(FoodBlocks.GLISTERING_MELON_SLICE, new Item.Properties()));
        FOOD_MAP.put("enchanted_golden_apple", (Item)new ModEnchantedGoldenAppleItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41489_(Foods.f_38829_), FoodBlocks.ENCHANTED_GOLDEN_APPLE));
        FOOD_MAP.put("chicken", (Item)FoodToBlocks.createItem(FoodBlocks.CHICKEN, Foods.f_38817_));
        FOOD_MAP.put("cooked_chicken", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_CHICKEN, Foods.f_38821_));
        FOOD_MAP.put("beef", (Item)FoodToBlocks.createItem(FoodBlocks.BEEF, Foods.f_38812_));
        FOOD_MAP.put("cooked_beef", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_BEEF, Foods.f_38820_));
        FOOD_MAP.put("mutton", (Item)FoodToBlocks.createItem(FoodBlocks.MUTTON, Foods.f_38835_));
        FOOD_MAP.put("cooked_mutton", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_MUTTON, Foods.f_38823_));
        FOOD_MAP.put("porkchop", (Item)FoodToBlocks.createItem(FoodBlocks.PORKCHOP, Foods.f_38798_));
        FOOD_MAP.put("cooked_porkchop", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_PORKCHOP, Foods.f_38824_));
        FOOD_MAP.put("rabbit", (Item)FoodToBlocks.createItem(FoodBlocks.RABBIT, Foods.f_38802_));
        FOOD_MAP.put("cooked_rabbit", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_RABBIT, Foods.f_38825_));
        FOOD_MAP.put("cod", (Item)FoodToBlocks.createItem(FoodBlocks.COD, Foods.f_38819_));
        FOOD_MAP.put("cooked_cod", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_COD, Foods.f_38822_));
        FOOD_MAP.put("salmon", (Item)FoodToBlocks.createItem(FoodBlocks.SALMON, Foods.f_38805_));
        FOOD_MAP.put("cooked_salmon", (Item)FoodToBlocks.createItem(FoodBlocks.COOKED_SALMON, Foods.f_38826_));
        FOOD_MAP.put("pufferfish", (Item)FoodToBlocks.createItem(FoodBlocks.PUFFERFISH, Foods.f_38800_));
        FOOD_MAP.put("tropical_fish", (Item)FoodToBlocks.createItem(FoodBlocks.TROPICAL_FISH, Foods.f_38809_));
        FOOD_MAP.put("rabbit_stew", (Item)new ModStewItem(new Item.Properties().m_41487_(1).m_41489_(Foods.f_38803_), FoodBlocks.RABBIT_STEW));
        FOOD_MAP.put("mushroom_stew", (Item)new ModStewItem(new Item.Properties().m_41487_(1).m_41489_(Foods.f_38834_), FoodBlocks.MUSHROOM_STEW));
        FOOD_MAP.put("beetroot_soup", (Item)new ModStewItem(new Item.Properties().m_41487_(1).m_41489_(Foods.f_38814_), FoodBlocks.BEETROOT_SOUP));
        FOOD_MAP.put("suspicious_stew", (Item)new ModSuspiciousStewItem(new Item.Properties().m_41487_(1).m_41489_(Foods.f_38807_), FoodBlocks.SUSPICIOUS_STEW));
        FOOD_MAP.put("bowl", (Item)new BlockItem(FoodBlocks.BOWL, new Item.Properties()));
        FOOD_MAP.put("milk_bucket", null);
        FOOD_MAP.put("pumpkin_pie", (Item)FoodToBlocks.createItem(FoodBlocks.PUMPKIN_PIE, Foods.f_38801_));
        FOOD_MAP.put("chorus_fruit", (Item)new ModChorusFruitItem(new Item.Properties().m_41489_(Foods.f_38818_), FoodBlocks.CHORUS_FRUIT));
        FOOD_MAP.put("egg", (Item)new ModEggItem(new Item.Properties(), FoodBlocks.EGG));
        FOOD_MAP.put("totem_of_undying", (Item)new BlockItem(FoodBlocks.TOTEM_OF_UNDYING, new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
        FOOD_MAP.put("potion", (Item)new ModPotionItem(FoodBlocks.POTION, new Item.Properties().m_41487_(1)));
        FOOD_MAP.put("glass_bottle", (Item)new ModGlassBottleItem(FoodBlocks.GLASS_BOTTLE, new Item.Properties()));
        FOOD_MAP.put("honey_bottle", null);
    }
}

