/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.jetbrains.annotations.NotNull;

public class IntegerPropertyManager {
    private static final Map<String, IntegerProperty> PROPERTY_CACHE = new HashMap<String, IntegerProperty>();
    private static PendingPropertyInfo pendingInfo = null;

    public static void preCache(String name, int max) {
        IntegerPropertyManager.preCache(name, 1, max);
    }

    public static void preCache(String name, int min, int max) {
        if (max == min) {
            --min;
        }
        pendingInfo = new PendingPropertyInfo(name, min, max);
    }

    public static IntegerProperty take() {
        if (pendingInfo == null) {
            throw new IllegalStateException("No pre-cached property found");
        }
        String key = IntegerPropertyManager.generateKey(IntegerPropertyManager.pendingInfo.name, IntegerPropertyManager.pendingInfo.min, IntegerPropertyManager.pendingInfo.max);
        if (PROPERTY_CACHE.containsKey(key)) {
            IntegerProperty property = PROPERTY_CACHE.get(key);
            IntegerPropertyManager.clearPending();
            return property;
        }
        IntegerProperty property = IntegerProperty.m_61631_((String)IntegerPropertyManager.pendingInfo.name, (int)IntegerPropertyManager.pendingInfo.min, (int)IntegerPropertyManager.pendingInfo.max);
        PROPERTY_CACHE.put(key, property);
        IntegerPropertyManager.clearPending();
        return property;
    }

    public static IntegerProperty create(String name, int max) {
        return IntegerPropertyManager.create(name, 1, max);
    }

    public static IntegerProperty create(String name, int min, int max) {
        String key;
        if (max == min) {
            --min;
        }
        if (PROPERTY_CACHE.containsKey(key = IntegerPropertyManager.generateKey(name, min, max))) {
            return PROPERTY_CACHE.get(key);
        }
        IntegerProperty property = IntegerProperty.m_61631_((String)name, (int)min, (int)max);
        PROPERTY_CACHE.put(key, property);
        return property;
    }

    private static String generateKey(String name, int min, int max) {
        return name + ":" + min + ":" + max;
    }

    private static void clearPending() {
        pendingInfo = null;
    }

    public static boolean hasPending() {
        return pendingInfo != null;
    }

    public static String getPendingInfo() {
        return pendingInfo != null ? pendingInfo.toString() : null;
    }

    public static void clearAll() {
        PROPERTY_CACHE.clear();
        IntegerPropertyManager.clearPending();
    }

    public static int getCacheSize() {
        return PROPERTY_CACHE.size();
    }

    private record PendingPropertyInfo(String name, int min, int max) {
        @Override
        @NotNull
        public String toString() {
            return "PendingPropertyInfo{name='" + this.name + "', min=" + this.min + ", max=" + this.max + "}";
        }
    }
}

