/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.dfood.block.FoodBlock;
import org.dfood.block.FoodBlockBuilder;
import org.dfood.block.entity.ComplexFoodBlockEntity;
import org.jetbrains.annotations.Nullable;

public class ComplexFoodBlock
extends FoodBlock
implements class_2343 {
    protected ComplexFoodBlock(class_4970.class_2251 settings, int maxFood, boolean isFood, @Nullable class_265 simpleShape, boolean useItemTranslationKey, @Nullable FoodBlock.EnforceAsItem cItem) {
        super(settings, maxFood, isFood, simpleShape, useItemTranslationKey, cItem);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ComplexFoodBlockEntity(pos, state);
    }

    @Override
    public boolean isSame(class_1799 stack, class_2680 state, @Nullable class_2586 blockEntity) {
        return super.isSame(stack, state, blockEntity);
    }

    @Override
    protected boolean tryAdd(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 handStack, @Nullable class_2586 blockEntity) {
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            class_2487 stackNbt = handStack.method_7985() ? handStack.method_7969().method_10553() : new class_2487();
            complexFoodBlockEntity.pushNbt(stackNbt);
        }
        return super.tryAdd(state, world, pos, player, handStack, blockEntity);
    }

    @Override
    public class_1799 createStack(int count, class_2680 state, @Nullable class_2586 blockEntity) {
        ComplexFoodBlockEntity complexFoodBlockEntity;
        class_2487 storedNbt;
        if (count <= 0 || count > this.MAX_FOOD) {
            throw new IllegalArgumentException("Count must be between 1 and " + this.MAX_FOOD);
        }
        class_1799 stack = new class_1799((class_1935)this.method_8389(), count);
        if (blockEntity instanceof ComplexFoodBlockEntity && (storedNbt = (complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity).popNbt()) != null && !storedNbt.method_33133()) {
            stack.method_7980(storedNbt);
        }
        return stack;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            class_2487 stackNbt = itemStack.method_7985() ? itemStack.method_7969().method_10553() : new class_2487();
            complexFoodBlockEntity.pushNbt(stackNbt);
            complexFoodBlockEntity.method_5431();
        }
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        int foodCount = (Integer)state.method_11654((class_2769)this.NUMBER_OF_FOOD);
        if (foodCount <= 0) {
            return Collections.emptyList();
        }
        class_2586 blockEntity = (class_2586)builder.method_51873(class_181.field_1228);
        if (blockEntity instanceof ComplexFoodBlockEntity) {
            ComplexFoodBlockEntity complexFoodBlockEntity = (ComplexFoodBlockEntity)blockEntity;
            ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
            for (int i = 0; i < foodCount; ++i) {
                droppedStacks.add(this.createStack(1, state, complexFoodBlockEntity));
            }
            return droppedStacks;
        }
        return Collections.singletonList(new class_1799((class_1935)this.method_8389(), foodCount));
    }

    public static class Builder
    extends FoodBlockBuilder<ComplexFoodBlock, Builder> {
        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        @Override
        protected ComplexFoodBlock createBlock() {
            return new ComplexFoodBlock(this.settings, this.maxFood, this.isFood, this.simpleShape, this.useItemTranslationKey, this.cItem);
        }
    }
}

