/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.dfood.block.ComplexFoodBlock;
import org.dfood.block.entity.ModBlockEntityTypes;
import org.dfood.util.DFoodUtils;
import org.jetbrains.annotations.Nullable;

public class ComplexFoodBlockEntity
extends class_2586 {
    protected final Stack<class_2487> nbtStack = new Stack();
    protected int maxCapacity;

    public ComplexFoodBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntityTypes.COMPLEX_FOOD, pos, state);
    }

    public ComplexFoodBlockEntity(class_2591<? extends ComplexFoodBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ComplexFoodBlock) {
            ComplexFoodBlock complexFoodBlock = (ComplexFoodBlock)class_22482;
            this.maxCapacity = complexFoodBlock.MAX_FOOD;
        }
    }

    public boolean pushNbt(@Nullable class_2487 nbt) {
        if (this.nbtStack.size() >= this.maxCapacity) {
            return false;
        }
        if (nbt == null) {
            nbt = new class_2487();
        }
        this.nbtStack.push(nbt);
        this.method_5431();
        return true;
    }

    @Nullable
    public class_2487 popNbt() {
        if (this.nbtStack.isEmpty()) {
            return null;
        }
        class_2487 popped = this.nbtStack.pop();
        this.method_5431();
        return popped;
    }

    @Nullable
    public class_2487 peekNbt() {
        return this.nbtStack.isEmpty() ? null : this.nbtStack.peek();
    }

    public int getNbtCount() {
        return this.nbtStack.size();
    }

    public boolean isFull() {
        return this.nbtStack.size() >= this.maxCapacity;
    }

    public boolean isEmpty() {
        return this.nbtStack.isEmpty();
    }

    public void clearNbt() {
        this.nbtStack.clear();
        this.method_5431();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 nbtList = new class_2499();
        nbtList.addAll(this.nbtStack);
        nbt.method_10566("NbtStack", (class_2520)nbtList);
        nbt.method_10569("MaxCapacity", this.maxCapacity);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.nbtStack.clear();
        if (nbt.method_10573("NbtStack", 9)) {
            class_2499 nbtList = nbt.method_10554("NbtStack", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                this.nbtStack.push(nbtList.method_10602(i));
            }
        }
        if (nbt.method_10573("MaxCapacity", 3)) {
            this.maxCapacity = nbt.method_10550("MaxCapacity");
        }
    }

    public List<class_2487> getAllNbt() {
        return new ArrayList<class_2487>(this.nbtStack);
    }

    public List<class_1799> getAllStack() {
        int count = DFoodUtils.getFoodBlockCount(this.method_11010());
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(count);
        for (int i = 0; i < count; ++i) {
            class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204().method_8389());
            stack.method_7980(this.getNbtAt(i));
            stacks.add(stack);
        }
        return stacks;
    }

    @Nullable
    public class_2487 getNbtAt(int index) {
        if (index < 0 || index >= this.nbtStack.size()) {
            return null;
        }
        return (class_2487)this.nbtStack.get(index);
    }
}

