/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.item;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface HaveBlock {
    public class_2248 getBlock();

    default public void appendBlocks(Map<class_2248, class_1792> map, class_1792 item) {
        map.put(this.getBlock(), item);
    }

    default public class_1269 place(class_1750 context) {
        if (!this.getBlock().method_45382(context.method_8045().method_45162())) {
            return class_1269.field_5814;
        }
        if (!context.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 itemPlacementContext = this.getPlacementContext(context);
        if (itemPlacementContext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = this.getPlacementState(itemPlacementContext);
        if (blockState == null) {
            return class_1269.field_5814;
        }
        if (!this.place(itemPlacementContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = itemPlacementContext.method_8037();
        class_1937 world = itemPlacementContext.method_8045();
        class_1657 playerEntity = itemPlacementContext.method_8036();
        class_1799 itemStack = itemPlacementContext.method_8041();
        class_2680 blockState2 = world.method_8320(blockPos);
        if (blockState2.method_27852(blockState.method_26204())) {
            blockState2 = this.placeFromNbt(blockPos, world, itemStack, blockState2);
            this.postPlacement(blockPos, world, playerEntity, itemStack, blockState2);
            blockState2.method_26204().method_9567(world, blockPos, blockState2, (class_1309)playerEntity, itemStack);
            if (playerEntity instanceof class_3222) {
                class_174.field_1191.method_23889((class_3222)playerEntity, blockPos, itemStack);
            }
        }
        class_2498 blockSoundGroup = blockState2.method_26231();
        world.method_8396(playerEntity, blockPos, this.getPlaceSound(blockState2), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
        world.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)playerEntity, (class_2680)blockState2));
        if (playerEntity == null || !playerEntity.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    @Nullable
    default public class_2680 getPlacementState(class_1750 context) {
        class_2680 blockState = this.getBlock().method_9605(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    default public class_3414 getPlaceSound(class_2680 state) {
        return state.method_26231().method_10598();
    }

    @Nullable
    default public class_1750 getPlacementContext(class_1750 context) {
        return context;
    }

    default public boolean postPlacement(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        return HaveBlock.writeNbtToBlockEntity(world, player, pos, stack);
    }

    private class_2680 placeFromNbt(class_2338 pos, class_1937 world, class_1799 stack, class_2680 state) {
        class_2680 blockState = state;
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null) {
            class_2487 nbtCompound2 = nbtCompound.method_10562("BlockStateTag");
            class_2689 stateManager = state.method_26204().method_9595();
            for (String string : nbtCompound2.method_10541()) {
                class_2769 property = stateManager.method_11663(string);
                if (property == null) continue;
                String string2 = Objects.requireNonNull(nbtCompound2.method_10580(string)).method_10714();
                blockState = HaveBlock.with(blockState, property, string2);
            }
        }
        if (blockState != state) {
            world.method_8652(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 with(class_2680 state, class_2769<T> property, String name) {
        return property.method_11900(name).map(value -> (class_2680)state.method_11657(property, value)).orElse(state);
    }

    default public boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 playerEntity = context.method_8036();
        class_3726 shapeContext = playerEntity == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)playerEntity);
        return (!this.checkStatePlacement() || state.method_26184((class_4538)context.method_8045(), context.method_8037())) && context.method_8045().method_8628(state, context.method_8037(), shapeContext);
    }

    default public boolean checkStatePlacement() {
        return true;
    }

    public static boolean writeNbtToBlockEntity(class_1937 world, @Nullable class_1657 player, class_2338 pos, class_1799 stack) {
        class_2586 blockEntity;
        class_2487 nbtCompound;
        MinecraftServer minecraftServer = world.method_8503();
        if (minecraftServer != null && (nbtCompound = HaveBlock.getBlockEntityNbt(stack)) != null && (blockEntity = world.method_8321(pos)) != null) {
            if (!(world.field_9236 || !blockEntity.method_11011() || player != null && player.method_7338())) {
                return false;
            }
            class_2487 nbtCompound2 = blockEntity.method_38244();
            class_2487 nbtCompound3 = nbtCompound2.method_10553();
            nbtCompound2.method_10543(nbtCompound);
            if (!nbtCompound2.equals((Object)nbtCompound3)) {
                blockEntity.method_11014(nbtCompound2);
                blockEntity.method_5431();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static class_2487 getBlockEntityNbt(class_1799 stack) {
        return stack.method_7941("BlockEntityTag");
    }

    default public boolean place(class_1750 context, class_2680 state) {
        return context.method_8045().method_8652(context.method_8037(), state, 11);
    }
}

