/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.mixin.ChunkGeneratorInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Utils {
    public static Optional<HolderSet.Named<Structure>> getStructureSet(ServerLevel level, ResourceLocation structures) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        return registry.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)structures));
    }

    private static Iterable<ChunkPos> generateOutwardPositions(final int centerX, final int centerY, final int minSize, final int maxSize) {
        return () -> new Iterator<ChunkPos>(){
            private int x;
            private int y;
            private int dx;
            private int dy;
            private int layer;
            private int steps;
            {
                this.x = minSize;
                this.y = -minSize;
                this.dx = 0;
                this.dy = -1;
                this.layer = 0;
                this.steps = 0;
            }

            @Override
            public boolean hasNext() {
                return Math.abs(this.x) <= maxSize && Math.abs(this.y) <= maxSize;
            }

            @Override
            public ChunkPos next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ChunkPos position = new ChunkPos(this.x + centerX, this.y + centerY);
                if (this.steps++ == this.layer) {
                    this.steps = 0;
                    ++this.layer;
                    int temp = this.dx;
                    this.dx = -this.dy;
                    this.dy = temp;
                }
                this.x += this.dx;
                this.y += this.dy;
                return position;
            }
        };
    }

    public static Vector3f calculateQuadraticBezier(Vector3f p0, Vector3f p1, Vector3f p2, float f) {
        float f2 = 1.0f - f;
        Vector3f term1 = new Vector3f((Vector3fc)p0).mul(f2 * f2);
        Vector3f term2 = new Vector3f((Vector3fc)p1).mul(2.0f * f2 * f);
        Vector3f term3 = new Vector3f((Vector3fc)p2).mul(f * f);
        return term1.add((Vector3fc)term2).add((Vector3fc)term3);
    }

    public static List<int[]> chunkCoordsInRadiusSorted(int centerCx, int centerCz, int radius) {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        for (int x = centerCx - radius; x <= centerCx + radius; ++x) {
            int z = centerCz - radius;
            while (z <= centerCz + radius) {
                coords.add(new int[]{x, z++});
            }
        }
        coords.sort(Comparator.comparingLong(a -> {
            long dx = a[0] - centerCx;
            long dz = a[1] - centerCz;
            return dx * dx + dz * dz;
        }));
        return coords;
    }

    public static class NearestMapStructureIterator {
        private final ServerLevel level;
        private final boolean skipKnownStructures;
        private final Map<RandomSpreadStructurePlacement, Set<Holder<Structure>>> placements;
        private final Iterator<ChunkPos> chunkPosIterator;
        private int scannedChunks = 0;

        public NearestMapStructureIterator(ServerLevel level, HolderSet<Structure> structure, BlockPos pos, int minSize, int maxSize, boolean skipKnownStructures) {
            this.level = level;
            this.skipKnownStructures = skipKnownStructures;
            ChunkGeneratorStructureState generatorState = level.m_7726_().m_255415_();
            this.placements = new Object2ObjectArrayMap();
            for (Holder holder : structure) {
                for (StructurePlacement placement : generatorState.m_255260_(holder)) {
                    if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
                    RandomSpreadStructurePlacement randomSpreadStructurePlacement = (RandomSpreadStructurePlacement)placement;
                    this.placements.computeIfAbsent(randomSpreadStructurePlacement, p -> new ObjectArraySet()).add(holder);
                }
            }
            if (this.placements.isEmpty()) {
                this.chunkPosIterator = Collections.emptyIterator();
            } else {
                int x = SectionPos.m_123171_((int)pos.m_123341_());
                int y = SectionPos.m_123171_((int)pos.m_123343_());
                this.chunkPosIterator = Utils.generateOutwardPositions(x, y, minSize, maxSize).iterator();
            }
        }

        public boolean hasNext() {
            return this.chunkPosIterator.hasNext();
        }

        public SearchResult next() {
            while (this.hasNext()) {
                if (++this.scannedChunks % 1000 == 0) {
                    Common.LOGGER.info("Scanned {} chunks", (Object)this.scannedChunks);
                }
                ChunkPos position = this.chunkPosIterator.next();
                StructureManager structureManager = this.level.m_215010_();
                for (Map.Entry<RandomSpreadStructurePlacement, Set<Holder<Structure>>> entry : this.placements.entrySet()) {
                    Pair<BlockPos, Holder<Structure>> pair = ChunkGeneratorInvoker.invokeGetStructureGeneratingAt(entry.getValue(), (LevelReader)this.level, structureManager, this.skipKnownStructures, (StructurePlacement)entry.getKey(), position);
                    if (pair == null) continue;
                    return new SearchResult((BlockPos)pair.getFirst(), (Holder<Structure>)((Holder)pair.getSecond()));
                }
            }
            throw new NoSuchElementException("No more structures found");
        }
    }

    public record SearchResult(BlockPos pos, Holder<Structure> structure) {
    }
}

