/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import net.conczin.immersive_gateways.BlockEntityTypes;
import net.conczin.immersive_gateways.block.GatewayBlockEntity;
import net.conczin.immersive_gateways.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GatewayBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final VoxelShape Y_AXIS_AABB = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);

    public GatewayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GatewayBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return GatewayBlock.m_152132_(blockEntityType, BlockEntityTypes.GATEWAY, this.getTicker(level));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level) {
        return level.f_46443_ ? (l, p, s, b) -> GatewayBlockEntity.clientTick(l, p, s, (GatewayBlockEntity)b) : (l, p, s, b) -> GatewayBlockEntity.serverTick((ServerLevel)l, p, s, (GatewayBlockEntity)b);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
        };
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (GatewayBlock.canEntityTeleport(entity)) {
                if (entity.m_20201_().m_20092_()) {
                    entity.m_20201_().m_20091_();
                } else {
                    GatewayBlockEntity.teleportEntity(serverLevel, pos, entity);
                }
            }
        }
    }

    public static boolean canEntityTeleport(Entity entity) {
        return EntitySelector.f_20408_.test(entity) && (!Config.getInstance().onlyPlayersCanTeleport || entity instanceof Player);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_();
            double z = (double)pos.m_123343_() + random.m_188500_();
            double ox = ((double)random.m_188501_() - 0.5) * 0.5;
            double oy = ((double)random.m_188501_() - 0.5) * 0.5;
            double oz = ((double)random.m_188501_() - 0.5) * 0.5;
            int k = random.m_188503_(2) * 2 - 1;
            if (level.m_8055_(pos.m_122024_()).m_60713_((Block)this) || level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)k;
                oz = random.m_188501_() * 2.0f * (float)k;
            } else {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)k;
                ox = random.m_188501_() * 2.0f * (float)k;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, ox, oy, oz);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }
}

