/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_gateways.BlockEntityTypes;
import net.conczin.immersive_gateways.Sounds;
import net.conczin.immersive_gateways.block.GatewayBlock;
import net.conczin.immersive_gateways.block.GatewayExecutorController;
import net.conczin.immersive_gateways.data.PortalDataManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class GatewayBlockEntity
extends BlockEntity {
    public static final double DISTANCE = 16.0;
    public static final int COOLDOWN = 30;
    public static final float OFFSET = 2.5f;
    public static Vector2f[] offsets = new Vector2f[]{new Vector2f(0.25f, 0.25f), new Vector2f(0.75f, 0.25f), new Vector2f(0.75f, 0.75f), new Vector2f(0.25f, 0.75f)};
    Vector3f[] offsets1;
    Vector3f[] offsets2;
    Quaternionf[] rotations;
    float[] lastTime = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    float[] time = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    boolean[] state = new boolean[]{false, false, false, false};
    Random random = new Random();
    int color = 0;
    static final Map<UUID, Long> lastCloseTick = new ConcurrentHashMap<UUID, Long>();

    private Vector3f[] getOffsets() {
        return this.getOffsets(new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)});
    }

    private float getRandom() {
        return this.random.nextFloat() * 2.0f - 1.0f;
    }

    private Vector3f offsetVector(Vector3f offset) {
        return new Vector3f(offset.x() + this.getRandom() * 2.5f, offset.y() + this.getRandom() * 2.5f, offset.z() + this.getRandom() * 2.5f);
    }

    private Vector3f[] getOffsets(Vector3f[] offset) {
        return new Vector3f[]{this.offsetVector(offset[0]), this.offsetVector(offset[1]), this.offsetVector(offset[2]), this.offsetVector(offset[3])};
    }

    public Quaternionf randomQuaternion() {
        float u1 = this.random.nextFloat();
        float u2 = this.random.nextFloat();
        float u3 = this.random.nextFloat();
        double theta1 = Math.PI * 2 * (double)u1;
        double theta2 = Math.PI * 2 * (double)u2;
        double s1 = Math.sqrt(1.0 - (double)u3);
        double s2 = Math.sqrt(u3);
        float x = (float)(s1 * Math.sin(theta1));
        float y = (float)(s1 * Math.cos(theta1));
        float z = (float)(s2 * Math.sin(theta2));
        float w = (float)(s2 * Math.cos(theta2));
        return new Quaternionf(x, y, z, w).normalize();
    }

    public GatewayBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityTypes.GATEWAY, pos, blockState);
        this.rotations = new Quaternionf[]{this.randomQuaternion(), this.randomQuaternion(), this.randomQuaternion(), this.randomQuaternion()};
        this.offsets1 = this.getOffsets();
        this.offsets2 = this.getOffsets(this.offsets1);
    }

    public Vector3d getPosition(BlockPos pos, BlockState state, int i) {
        Direction.Axis value = (Direction.Axis)state.m_61143_(GatewayBlock.AXIS);
        return new Vector3d((double)((float)pos.m_123341_() + (value == Direction.Axis.X ? GatewayBlockEntity.offsets[i].x : (value == Direction.Axis.Y ? GatewayBlockEntity.offsets[i].x : 0.5f))), (double)((float)pos.m_123342_() + (value == Direction.Axis.X ? GatewayBlockEntity.offsets[i].y : (value == Direction.Axis.Y ? 0.5f : GatewayBlockEntity.offsets[i].y))), (double)((float)pos.m_123343_() + (value == Direction.Axis.X ? 0.5f : (value == Direction.Axis.Y ? GatewayBlockEntity.offsets[i].y : GatewayBlockEntity.offsets[i].x))));
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, GatewayBlockEntity blockEntity) {
        for (int i = 0; i < 4; ++i) {
            long time = level.m_46467_();
            if ((time ^ (long)pos.m_123341_() * 77L ^ (long)pos.m_123342_() * 66L ^ (long)pos.m_123343_() * 55L + (long)i * 44L) % 30L == 0L) {
                Vector3d position = blockEntity.getPosition(pos, state, i);
                Player player = level.m_45924_(position.x, position.y, position.z, 32.0, false);
                boolean isClose = false;
                if (player != null) {
                    double distance = player.m_20275_(position.x, position.y, position.z);
                    if (distance < 256.0) {
                        lastCloseTick.put(player.m_20148_(), time);
                    }
                    isClose = lastCloseTick.getOrDefault(player.m_20148_(), 0L) + 30L > time;
                }
                blockEntity.state[i] = isClose;
            }
            blockEntity.lastTime[i] = blockEntity.time[i];
            blockEntity.time[i] = blockEntity.state[i] ? Math.min(1.0f, blockEntity.time[i] + 0.033333335f) : Math.max(0.0f, blockEntity.time[i] - 0.033333335f);
            float threshold = 0.75f;
            if (blockEntity.time[i] > threshold && blockEntity.lastTime[i] <= threshold) {
                GatewayBlockEntity.playSound(level, pos, Sounds.ASSEMBLE);
                continue;
            }
            if (!(blockEntity.time[i] <= threshold) || !(blockEntity.lastTime[i] > threshold)) continue;
            GatewayBlockEntity.playSound(level, pos, Sounds.DISASSEMBLE);
        }
    }

    public static void serverTick(ServerLevel level, BlockPos pos, BlockState state, GatewayBlockEntity blockEntity) {
        if (blockEntity.color == 0) {
            blockEntity.color = 1;
            PortalDataManager.PortalPair pair = PortalDataManager.search(level, pos);
            if (pair.first.resolved() && pair.second.resolved()) {
                GatewayBlockEntity.applyPortalColor(level, pos, blockEntity, pair);
            } else {
                GatewayExecutorController.submit(() -> {
                    PortalDataManager.PortalPair resolvedPair = PortalDataManager.searchAndResolve(level, pos);
                    GatewayBlockEntity.applyPortalColor(level, pos, blockEntity, resolvedPair);
                });
            }
        }
    }

    private static void applyPortalColor(ServerLevel level, BlockPos pos, GatewayBlockEntity blockEntity, PortalDataManager.PortalPair pair) {
        blockEntity.setColor(pair.getTarget(pos).color());
        level.m_7726_().m_8450_(pos);
    }

    public void setColor(int color) {
        this.color = color;
        this.m_6596_();
    }

    private static void playSound(Level level, BlockPos pos, SoundEvent sound) {
        float volume = level.f_46441_.m_188501_() * 0.1f + 0.1f;
        float pitch = level.f_46441_.m_188501_() * 0.4f + 0.8f;
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, volume, pitch);
    }

    public static void teleportEntity(ServerLevel level, BlockPos pos, Entity entity) {
        GatewayBlockEntity.playSound((Level)level, pos, Sounds.GATEWAY);
        entity.m_20091_();
        PortalDataManager.PortalPair pair = PortalDataManager.search(level, pos);
        PortalDataManager.Portal portal = pair.getTarget(pos);
        if (!portal.resolved()) {
            entity.m_213846_((Component)Component.m_237115_((String)"immersive_gateways.not_loaded_yet"));
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50, 0));
        }
        BlockPos targetPos = portal.getSafePosition(level);
        double portalCenterX = (double)(portal.boundingBox().m_162399_() + portal.boundingBox().m_162395_()) / 2.0;
        double portalCenterZ = (double)(portal.boundingBox().m_162401_() + portal.boundingBox().m_162398_()) / 2.0;
        double deltaX = portalCenterX - ((double)targetPos.m_123341_() + 0.5);
        double deltaZ = portalCenterZ - ((double)targetPos.m_123343_() + 0.5);
        float targetYRot = (float)(Math.toDegrees(Math.atan2(-deltaZ, deltaX)) + 360.0) % 360.0f;
        targetYRot = Math.round(targetYRot / 90.0f) * 90;
        double targetX = (double)targetPos.m_123341_() + 0.5;
        double targetY = targetPos.m_123342_();
        double targetZ = (double)targetPos.m_123343_() + 0.5;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.m_8999_(level, targetX, targetY, targetZ, targetYRot, serverPlayer.m_146909_());
            serverPlayer.m_5616_(targetYRot);
            serverPlayer.f_20886_ = targetYRot;
        } else {
            entity.m_20324_(targetX, targetY, targetZ);
            entity.m_146922_(targetYRot);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ instanceof ClientLevel) {
            this.color = tag.m_128451_("Color");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Color", (Tag)IntTag.m_128679_((int)this.color));
        return tag;
    }

    public int getColor() {
        return this.color;
    }
}

