/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.IrisCompat;
import net.conczin.immersive_gateways.Utils;
import net.conczin.immersive_gateways.block.GatewayBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GatewayBlockEntityRenderer<T extends GatewayBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation BLANK_LOCATION = Common.locate("textures/entity/white.png");
    public static final Vector3f[] NORMALS = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};

    public GatewayBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 0);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 1);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 2);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 3);
    }

    private void renderRuneCube(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, int face) {
        BlockPos blockPos = blockEntity.m_58899_();
        Vector3d position = ((GatewayBlockEntity)((Object)blockEntity)).getPosition(blockPos, blockEntity.m_58900_(), face);
        float blinkDuration = 0.2f;
        float f = ((GatewayBlockEntity)((Object)blockEntity)).lastTime[face] * (1.0f - partialTick) + ((GatewayBlockEntity)((Object)blockEntity)).time[face] * partialTick;
        float f2 = 1.0f - Math.min((float)1.0f, (float)(f / (1.0f - blinkDuration)));
        if ((double)f <= 0.0) {
            return;
        }
        Vector3f offset = Utils.calculateQuadraticBezier(new Vector3f(0.0f, 0.0f, 0.0f), ((GatewayBlockEntity)((Object)blockEntity)).offsets1[face], ((GatewayBlockEntity)((Object)blockEntity)).offsets2[face], f2);
        Quaternionf rotation = new Quaternionf();
        rotation.slerp((Quaternionfc)((GatewayBlockEntity)((Object)blockEntity)).rotations[face], f2);
        float size = 0.25f * Math.sqrt((float)f);
        float brightness = Math.max((float)0.0f, (float)(1.0f - Math.abs((float)(1.0f - blinkDuration - f)) / blinkDuration));
        poseStack.m_85836_();
        poseStack.m_85837_(position.x - (double)blockPos.m_123341_() + (double)offset.x, position.y - (double)blockPos.m_123342_() + (double)offset.y, position.z - (double)blockPos.m_123343_() + (double)offset.z);
        poseStack.m_252781_(rotation);
        poseStack.m_85841_(size, size, size);
        if (IrisCompat.isShaderPackInUse()) {
            this.renderCubeIris((GatewayBlockEntity)((Object)blockEntity), partialTick, poseStack, buffer, packedLight, packedOverlay, ((GatewayBlockEntity)((Object)blockEntity)).getColor());
        } else {
            this.renderCube(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_173242_()));
            this.renderCube(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_234338_((ResourceLocation)BLANK_LOCATION)), packedLight, packedOverlay, brightness, ((GatewayBlockEntity)((Object)blockEntity)).getColor());
        }
        poseStack.m_85849_();
    }

    private void renderCube(PoseStack.Pose pose, VertexConsumer consumer) {
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.renderFace(pose, consumer, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        this.renderFace(pose, consumer, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f);
    }

    private void renderCube(PoseStack.Pose pose, VertexConsumer consumer, int light, int overlay, float brightness, int color) {
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1, light, overlay, brightness, color);
        this.renderFace(pose, consumer, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 2, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 3, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 4, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 5, light, overlay, brightness, color);
    }

    private void renderFace(PoseStack.Pose pose, VertexConsumer consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3) {
        consumer.m_252986_(pose.m_252922_(), x0, y0, z0).m_5752_();
        consumer.m_252986_(pose.m_252922_(), x1, y0, z1).m_5752_();
        consumer.m_252986_(pose.m_252922_(), x1, y1, z2).m_5752_();
        consumer.m_252986_(pose.m_252922_(), x0, y1, z3).m_5752_();
    }

    private void renderFace(PoseStack.Pose pose, VertexConsumer consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, int face, int light, int overlay, float brightness, int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = 0.15f + 0.25f * brightness;
        float u = Math.floor((float)((float)face / 2.0f)) * 6.0f;
        float v = (float)face % 2.0f * 6.0f;
        Vector4f p = new Vector4f();
        Vector3f n = pose.m_252943_().transform(new Vector3f((Vector3fc)NORMALS[face]));
        pose.m_252922_().transform(x0, y0, z0, 1.0f, p);
        consumer.m_5954_(p.x(), p.y(), p.z(), r, g, b, a, u / 32.0f, v / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.m_252922_().transform(x1, y0, z1, 1.0f, p);
        consumer.m_5954_(p.x(), p.y(), p.z(), r, g, b, a, (u + 6.0f) / 32.0f, v / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.m_252922_().transform(x1, y1, z2, 1.0f, p);
        consumer.m_5954_(p.x(), p.y(), p.z(), r, g, b, a, (u + 6.0f) / 32.0f, (v + 6.0f) / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.m_252922_().transform(x0, y1, z3, 1.0f, p);
        consumer.m_5954_(p.x(), p.y(), p.z(), r, g, b, a, u / 32.0f, (v + 6.0f) / 32.0f, overlay, light, n.x(), n.y(), n.z());
    }

    public void renderCubeIris(GatewayBlockEntity entity, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay, int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)TheEndPortalRenderer.f_112627_));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float progress = (entity.m_58904_() == null ? 0.0f : (float)entity.m_58904_().m_46468_() + tickDelta) * 0.05f * 0.01f % 1.0f;
        float topHeight = 1.0f;
        float bottomHeight = -1.0f;
        this.quad(vertexConsumer, pose, normal, Direction.UP, progress, overlay, light, -1.0f, topHeight, 1.0f, 1.0f, topHeight, 1.0f, 1.0f, topHeight, -1.0f, -1.0f, topHeight, -1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, Direction.DOWN, progress, overlay, light, -1.0f, bottomHeight, 1.0f, -1.0f, bottomHeight, -1.0f, 1.0f, bottomHeight, -1.0f, 1.0f, bottomHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, Direction.NORTH, progress, overlay, light, -1.0f, topHeight, -1.0f, 1.0f, topHeight, -1.0f, 1.0f, bottomHeight, -1.0f, -1.0f, bottomHeight, -1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, Direction.WEST, progress, overlay, light, -1.0f, topHeight, 1.0f, -1.0f, topHeight, -1.0f, -1.0f, bottomHeight, -1.0f, -1.0f, bottomHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, Direction.SOUTH, progress, overlay, light, -1.0f, topHeight, 1.0f, -1.0f, bottomHeight, 1.0f, 1.0f, bottomHeight, 1.0f, 1.0f, topHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, Direction.EAST, progress, overlay, light, 1.0f, topHeight, 1.0f, 1.0f, bottomHeight, 1.0f, 1.0f, bottomHeight, -1.0f, 1.0f, topHeight, -1.0f, r, g, b);
    }

    private void quad(VertexConsumer vertexConsumer, Matrix4f pose, Matrix3f normal, Direction direction, float progress, int overlay, int light, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b) {
        float nx = direction.m_122429_();
        float ny = direction.m_122430_();
        float nz = direction.m_122431_();
        vertexConsumer.m_252986_(pose, x1, y1, z1).m_85950_(r, g, b, 1.0f).m_7421_(0.0f + progress, 0.0f + progress).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vertexConsumer.m_252986_(pose, x2, y2, z2).m_85950_(r, g, b, 1.0f).m_7421_(0.0f + progress, 0.1f + progress).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vertexConsumer.m_252986_(pose, x3, y3, z3).m_85950_(r, g, b, 1.0f).m_7421_(0.1f + progress, 0.1f + progress).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
        vertexConsumer.m_252986_(pose, x4, y4, z4).m_85950_(r, g, b, 1.0f).m_7421_(0.1f + progress, 0.0f + progress).m_86008_(overlay).m_85969_(light).m_252939_(normal, nx, ny, nz).m_5752_();
    }
}

