/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.conczin.immersive_gateways.Common;

public final class GatewayExecutorController {
    private static ExecutorService executor;

    private GatewayExecutorController() {
    }

    private static ExecutorService createExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Immersive Gateways Searcher");
            return thread;
        });
    }

    private static synchronized ExecutorService ensureExecutor() {
        if (executor == null || executor.isShutdown()) {
            executor = GatewayExecutorController.createExecutor();
            Common.LOGGER.debug("Gateway executor initialized");
        }
        return executor;
    }

    public static void submit(Runnable task) {
        GatewayExecutorController.ensureExecutor().execute(task);
    }

    public static synchronized void reset() {
        GatewayExecutorController.shutdownInternal();
        executor = GatewayExecutorController.createExecutor();
        Common.LOGGER.debug("Gateway executor reset");
    }

    public static synchronized void shutdown() {
        GatewayExecutorController.shutdownInternal();
    }

    private static void shutdownInternal() {
        if (executor != null) {
            executor.shutdownNow();
            executor = null;
            Common.LOGGER.debug("Gateway executor shut down");
        }
    }
}

