/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.conczin.immersive_gateways.Blocks;
import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.Utils;
import net.conczin.immersive_gateways.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;

public class PortalDataManager {
    public static long toLong(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static PortalDataLookup getState(ServerLevel level) {
        return (PortalDataLookup)level.m_8895_().m_164861_(PortalDataLookup::load, PortalDataLookup::new, "immersive_gateways");
    }

    public static synchronized PortalPair search(ServerLevel level, BlockPos pos) {
        PortalDataLookup state = PortalDataManager.getState(level);
        PortalPair portal = state.search(pos);
        if (portal == null) {
            Config c = Config.getInstance();
            float distance = level.f_46441_.m_188501_() * (float)(c.maxDistance - c.minDistance) + (float)c.minDistance;
            double angle = (double)level.f_46441_.m_188501_() * Math.PI;
            BlockPos target = new BlockPos((int)((double)pos.m_123341_() + Math.cos(angle) * (double)distance), pos.m_123342_(), (int)((double)pos.m_123343_() + Math.sin(angle) * (double)distance));
            portal = new PortalPair(new Portal(PortalDataManager.findPortalBoundingBox(level, pos), PortalDataManager.getColor(level, pos), true), new Portal(BoundingBox.m_162375_((Vec3i)target, (Vec3i)target), -1, false));
            state.add(portal);
            Common.LOGGER.info("New draft portal created.");
        }
        return portal;
    }

    public static PortalPair searchAndResolve(ServerLevel level, BlockPos pos) {
        PortalDataLookup state = PortalDataManager.getState(level);
        PortalPair portal = PortalDataManager.search(level, pos);
        if (!portal.second.resolved()) {
            portal.second = PortalDataManager.resolve(state, portal.second, level);
            state.add(portal);
        }
        if (!portal.second.resolved()) {
            portal.second = PortalDataManager.resolve(state, portal.second, level);
            state.add(portal);
        }
        return portal;
    }

    private static Portal resolve(PortalDataLookup state, Portal portal, ServerLevel level) {
        BlockPos target = portal.boundingBox().m_162394_();
        Config c = Config.getInstance();
        Utils.NearestMapStructureIterator structures = Utils.getStructureSet(level, Common.locate("portal")).map(s -> new Utils.NearestMapStructureIterator(level, (HolderSet<Structure>)s, target, 0, c.maxScanDistanceInChunks, false)).orElse(null);
        if (structures == null) {
            Common.LOGGER.warn("No portal structures found.");
            return portal.resolve();
        }
        BlockPos candidate = null;
        while (structures.hasNext()) {
            Utils.SearchResult result = structures.next();
            if (state.search(result.pos()) != null) continue;
            candidate = result.pos();
            break;
        }
        if (candidate == null) {
            Common.LOGGER.warn("No nearby portal not found, giving up.");
            return portal.resolve();
        }
        BoundingBox boundingBox = PortalDataManager.findPortalBoundingBox(level, candidate);
        return new Portal(boundingBox, PortalDataManager.getColor(level, candidate), true);
    }

    private static BoundingBox estimateBoundingBox(ServerLevel level, BlockPos pos) {
        int minX = pos.m_123341_();
        int minY = pos.m_123342_();
        int minZ = pos.m_123343_();
        int maxX = pos.m_123341_();
        int maxY = pos.m_123342_();
        int maxZ = pos.m_123343_();
        HashSet<BlockPos> open = new HashSet<BlockPos>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        open.add(pos);
        closed.add(pos);
        while (!open.isEmpty()) {
            BlockPos current = (BlockPos)open.iterator().next();
            open.remove(current);
            if (!level.m_8055_(current).m_60713_(Blocks.GATEWAY)) continue;
            minX = Math.min(minX, current.m_123341_());
            minY = Math.min(minY, current.m_123342_());
            minZ = Math.min(minZ, current.m_123343_());
            maxX = Math.max(maxX, current.m_123341_());
            maxY = Math.max(maxY, current.m_123342_());
            maxZ = Math.max(maxZ, current.m_123343_());
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor = current.m_7918_(x, y, z);
                        if (closed.contains(neighbor)) continue;
                        open.add(neighbor);
                        closed.add(neighbor);
                    }
                }
            }
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static BoundingBox findPortalBoundingBox(ServerLevel level, BlockPos pos) {
        long time = System.nanoTime();
        BlockPos improvedPos = PortalDataManager.findBlockInArea(level, pos);
        if (improvedPos == null) {
            Common.LOGGER.warn("Failed to find gateway block near {}.", (Object)pos);
            return BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos);
        }
        BoundingBox boundingBox = PortalDataManager.estimateBoundingBox(level, improvedPos);
        long delta = System.nanoTime() - time;
        Common.LOGGER.info("Exit search took {} ms.", (Object)(delta / 1000000L));
        return boundingBox;
    }

    private static BlockPos findBlockInArea(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos gatewayPos = new BlockPos.MutableBlockPos();
        int centerCx = SectionPos.m_123171_((int)pos.m_123341_());
        int centerCz = SectionPos.m_123171_((int)pos.m_123343_());
        for (int[] coord : Utils.chunkCoordsInRadiusSorted(centerCx, centerCz, 3)) {
            int cx = coord[0];
            int cz = coord[1];
            LevelChunk chunk = level.m_6325_(cx, cz);
            for (int cy = 0; cy < chunk.m_151559_(); ++cy) {
                LevelChunkSection section = chunk.m_183278_(cy);
                if (section.m_188008_() || !section.m_63002_(s -> s.m_60713_(Blocks.GATEWAY))) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            gatewayPos.m_122178_(SectionPos.m_175554_((int)cx, (int)x), SectionPos.m_175554_((int)chunk.m_151568_(cy), (int)y), SectionPos.m_175554_((int)cz, (int)z));
                            if (!chunk.m_8055_((BlockPos)gatewayPos).m_60713_(Blocks.GATEWAY)) continue;
                            return gatewayPos;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static int getColor(ServerLevel level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        ResourceLocation resourceLocation = biome.m_203543_().map(ResourceKey::m_135782_).orElse(new ResourceLocation("minecraft:plains"));
        if (!Config.getInstance().colors.containsKey(resourceLocation.toString())) {
            Common.LOGGER.info("Biome {} not found in color config, using default foliage color.", (Object)resourceLocation);
        }
        return Config.getInstance().colors.getOrDefault(resourceLocation.toString(), ((Biome)biome.m_203334_()).m_47542_());
    }

    public static class PortalDataLookup
    extends SavedData {
        final Set<PortalPair> portals = new HashSet<PortalPair>();
        final Map<Long, Set<PortalPair>> lookup = new HashMap<Long, Set<PortalPair>>();

        public static PortalDataLookup load(CompoundTag nbt) {
            PortalDataLookup c = new PortalDataLookup();
            for (String key : nbt.m_128431_()) {
                PortalPair pair = PortalPair.load(nbt.m_128423_(key));
                c.portals.add(pair);
                c.populateLookup(pair);
            }
            return c;
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            int index = 0;
            for (PortalPair pair : this.portals) {
                nbt.m_128365_(String.valueOf(index), pair.save());
                ++index;
            }
            return nbt;
        }

        public synchronized void add(PortalPair data) {
            this.portals.add(data);
            this.populateLookup(data);
            this.m_77762_();
        }

        private void populateLookup(PortalPair data) {
            this.populateLookup(data, data.first);
            this.populateLookup(data, data.second);
        }

        private void populateLookup(PortalPair data, Portal portal) {
            int minX = portal.boundingBox().m_162395_() >> 4;
            int minZ = portal.boundingBox().m_162398_() >> 4;
            int maxX = portal.boundingBox().m_162399_() >> 4;
            int maxZ = portal.boundingBox().m_162401_() >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    long cellId = PortalDataManager.toLong(x, z);
                    this.lookup.computeIfAbsent(cellId, k -> new HashSet()).add(data);
                }
            }
        }

        public PortalPair search(BlockPos pos) {
            int cz;
            int cx = pos.m_123341_() >> 4;
            long cellId = PortalDataManager.toLong(cx, cz = pos.m_123343_() >> 4);
            Set<PortalPair> candidates = this.lookup.get(cellId);
            if (candidates != null) {
                for (PortalPair candidate : candidates) {
                    if (!candidate.first.boundingBox().m_71051_((Vec3i)pos) && !candidate.second.boundingBox().m_71051_((Vec3i)pos)) continue;
                    return candidate;
                }
            }
            return null;
        }
    }

    public static final class PortalPair {
        public static final Codec<PortalPair> CODEC = RecordCodecBuilder.create(pair -> pair.group((App)Portal.CODEC.fieldOf("first").forGetter(PortalPair::first), (App)Portal.CODEC.fieldOf("second").forGetter(PortalPair::second)).apply((Applicative)pair, PortalPair::new));
        public Portal first;
        public Portal second;

        public PortalPair(Portal first, Portal second) {
            this.first = first;
            this.second = second;
        }

        public static PortalPair load(Tag nbt) {
            return (PortalPair)CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)Common.LOGGER).error(arg_0)).orElseThrow();
        }

        public Tag save() {
            return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).resultOrPartial(arg_0 -> ((Logger)Common.LOGGER).error(arg_0)).orElseThrow();
        }

        public Portal first() {
            return this.first;
        }

        public Portal second() {
            return this.second;
        }

        public Portal getTarget(BlockPos pos) {
            double dist2;
            double dist1 = this.first.boundingBox.m_162394_().m_123331_((Vec3i)pos);
            return dist1 < (dist2 = this.second.boundingBox.m_162394_().m_123331_((Vec3i)pos)) ? this.second : this.first;
        }
    }

    public record Portal(BoundingBox boundingBox, int color, boolean resolved) {
        public static final Codec<Portal> CODEC = RecordCodecBuilder.create(portal -> portal.group((App)BoundingBox.f_162354_.fieldOf("boundingBox").forGetter(Portal::boundingBox), (App)Codec.INT.fieldOf("color").forGetter(Portal::color), (App)Codec.BOOL.fieldOf("resolved").forGetter(Portal::resolved)).apply((Applicative)portal, Portal::new));

        public Portal resolve() {
            return new Portal(this.boundingBox, this.color, true);
        }

        public BlockPos getSafePosition(ServerLevel level) {
            LinkedList<BlockPos> candidates = new LinkedList<BlockPos>();
            if (this.boundingBox.m_71058_() > 1) {
                int z = (this.boundingBox.m_162398_() + this.boundingBox.m_162401_()) / 2;
                candidates.add(new BlockPos(this.boundingBox.m_162395_() - 1, this.boundingBox.m_162396_(), z));
                candidates.add(new BlockPos(this.boundingBox.m_162399_() + 1, this.boundingBox.m_162396_(), z));
            }
            if (this.boundingBox.m_71056_() > 1) {
                int x = (this.boundingBox.m_162395_() + this.boundingBox.m_162399_()) / 2;
                candidates.add(new BlockPos(x, this.boundingBox.m_162396_(), this.boundingBox.m_162398_() - 1));
                candidates.add(new BlockPos(x, this.boundingBox.m_162396_(), this.boundingBox.m_162401_() + 1));
            }
            for (int y = this.boundingBox.m_162396_(); y <= level.m_151558_(); ++y) {
                for (BlockPos candidate : candidates) {
                    BlockPos pos = new BlockPos(candidate.m_123341_(), y, candidate.m_123343_());
                    if (!level.m_8055_(pos).m_60795_() || !level.m_8055_(pos.m_7918_(0, 1, 0)).m_60795_()) continue;
                    return pos;
                }
            }
            return this.boundingBox.m_162394_();
        }
    }
}

