/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.item;

import java.util.HashSet;
import net.conczin.immersive_gateways.Blocks;
import net.conczin.immersive_gateways.block.GatewayBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class GatewayItem
extends Item {
    public GatewayItem(Item.Properties properties) {
        super(properties);
    }

    private BoundingBox getBoundingBox(Level level, BlockPos pos) {
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        HashSet<BlockPos> todo = new HashSet<BlockPos>();
        todo.add(pos);
        int minX = pos.m_123341_();
        int minY = pos.m_123342_();
        int minZ = pos.m_123343_();
        int maxX = pos.m_123341_();
        int maxY = pos.m_123342_();
        int maxZ = pos.m_123343_();
        while (!todo.isEmpty()) {
            BlockPos current = (BlockPos)todo.iterator().next();
            todo.remove(current);
            done.add(current);
            if (level.m_8055_(current).m_60795_()) continue;
            for (Direction direction : Direction.values()) {
                BlockPos neighbor = current.m_121945_(direction);
                if (done.contains(neighbor)) continue;
                done.add(neighbor);
                todo.add(neighbor);
            }
            minX = Math.min(minX, current.m_123341_());
            minY = Math.min(minY, current.m_123342_());
            minZ = Math.min(minZ, current.m_123343_());
            maxX = Math.max(maxX, current.m_123341_());
            maxY = Math.max(maxY, current.m_123342_());
            maxZ = Math.max(maxZ, current.m_123343_());
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void fillCaveAir(Level level, BlockPos pos) {
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        HashSet<BlockPos> todo = new HashSet<BlockPos>();
        HashSet<BlockPos> toReplace = new HashSet<BlockPos>();
        todo.add(pos);
        while (!todo.isEmpty()) {
            BlockPos current = (BlockPos)todo.iterator().next();
            todo.remove(current);
            done.add(current);
            if (level.m_8055_(current).m_60795_()) {
                toReplace.add(current);
                for (Direction direction : Direction.values()) {
                    BlockPos neighbor = current.m_121945_(direction);
                    if (neighbor.m_123342_() > pos.m_123342_() || done.contains(neighbor)) continue;
                    done.add(neighbor);
                    todo.add(neighbor);
                }
            }
            if (toReplace.size() <= 10000) continue;
            return;
        }
        for (BlockPos p : toReplace) {
            level.m_7731_(p, net.minecraft.world.level.block.Blocks.f_50627_.m_49966_(), 3);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        Direction.Axis axis = context.m_43723_() != null && direction.m_122434_().m_122478_() ? Direction.m_122364_((double)((double)context.m_43723_().m_146908_() + 90.0)).m_122434_() : Direction.Axis.Y;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StructureBlockEntity) {
            StructureBlockEntity structure = (StructureBlockEntity)blockEntity;
            structure.m_59860_(StructureMode.SAVE);
            BoundingBox boundingBox = this.getBoundingBox(level, pos);
            structure.m_59885_(new BlockPos(boundingBox.m_162395_() - pos.m_123341_(), boundingBox.m_162396_() - pos.m_123342_(), boundingBox.m_162398_() - pos.m_123343_()));
            structure.m_155797_(new Vec3i(boundingBox.m_162399_() - boundingBox.m_162395_() + 1, boundingBox.m_162400_() - boundingBox.m_162396_() + 1, boundingBox.m_162401_() - boundingBox.m_162398_() + 1));
            structure.m_59830_();
            return InteractionResult.CONSUME;
        }
        if (context.m_43723_().m_21206_() == context.m_43722_()) {
            if (!context.m_43725_().f_46443_) {
                this.fillCaveAir(level, pos.m_7918_(0, 1, 0));
                context.m_43723_().m_213846_((Component)Component.m_237113_((String)"Filled everything below with cave air!"));
            }
            return InteractionResult.CONSUME;
        }
        for (int i = 0; i < 8 && (state = level.m_8055_(pos = pos.m_121955_(direction.m_122436_()))).m_60795_(); ++i) {
            BlockState blockState = (BlockState)Blocks.GATEWAY.m_49966_().m_61124_(GatewayBlock.AXIS, (Comparable)axis);
            level.m_7731_(pos, blockState, 3);
        }
        return InteractionResult.CONSUME;
    }
}

