/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.mixin.ChunkGeneratorInvoker;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Utils {
    public static Optional<class_6885.class_6888<class_3195>> getStructureSet(class_3218 level, class_2960 structures) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        return registry.method_40266(class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)structures));
    }

    private static Iterable<class_1923> generateOutwardPositions(final int centerX, final int centerY, final int minSize, final int maxSize) {
        return () -> new Iterator<class_1923>(){
            private int x;
            private int y;
            private int dx;
            private int dy;
            private int layer;
            private int steps;
            {
                this.x = minSize;
                this.y = -minSize;
                this.dx = 0;
                this.dy = -1;
                this.layer = 0;
                this.steps = 0;
            }

            @Override
            public boolean hasNext() {
                return Math.abs(this.x) <= maxSize && Math.abs(this.y) <= maxSize;
            }

            @Override
            public class_1923 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                class_1923 position = new class_1923(this.x + centerX, this.y + centerY);
                if (this.steps++ == this.layer) {
                    this.steps = 0;
                    ++this.layer;
                    int temp = this.dx;
                    this.dx = -this.dy;
                    this.dy = temp;
                }
                this.x += this.dx;
                this.y += this.dy;
                return position;
            }
        };
    }

    public static Vector3f calculateQuadraticBezier(Vector3f p0, Vector3f p1, Vector3f p2, float f) {
        float f2 = 1.0f - f;
        Vector3f term1 = new Vector3f((Vector3fc)p0).mul(f2 * f2);
        Vector3f term2 = new Vector3f((Vector3fc)p1).mul(2.0f * f2 * f);
        Vector3f term3 = new Vector3f((Vector3fc)p2).mul(f * f);
        return term1.add((Vector3fc)term2).add((Vector3fc)term3);
    }

    public static List<int[]> chunkCoordsInRadiusSorted(int centerCx, int centerCz, int radius) {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        for (int x = centerCx - radius; x <= centerCx + radius; ++x) {
            int z = centerCz - radius;
            while (z <= centerCz + radius) {
                coords.add(new int[]{x, z++});
            }
        }
        coords.sort(Comparator.comparingLong(a -> {
            long dx = a[0] - centerCx;
            long dz = a[1] - centerCz;
            return dx * dx + dz * dz;
        }));
        return coords;
    }

    public static class NearestMapStructureIterator {
        private final class_3218 level;
        private final boolean skipKnownStructures;
        private final Map<class_6872, Set<class_6880<class_3195>>> placements;
        private final Iterator<class_1923> chunkPosIterator;
        private int scannedChunks = 0;

        public NearestMapStructureIterator(class_3218 level, class_6885<class_3195> structure, class_2338 pos, int minSize, int maxSize, boolean skipKnownStructures) {
            this.level = level;
            this.skipKnownStructures = skipKnownStructures;
            class_7869 generatorState = level.method_14178().method_46642();
            this.placements = new Object2ObjectArrayMap();
            for (class_6880 holder : structure) {
                for (class_6874 placement : generatorState.method_46708(holder)) {
                    if (!(placement instanceof class_6872)) continue;
                    class_6872 randomSpreadStructurePlacement = (class_6872)placement;
                    this.placements.computeIfAbsent(randomSpreadStructurePlacement, p -> new ObjectArraySet()).add(holder);
                }
            }
            if (this.placements.isEmpty()) {
                this.chunkPosIterator = Collections.emptyIterator();
            } else {
                int x = class_4076.method_18675((int)pos.method_10263());
                int y = class_4076.method_18675((int)pos.method_10260());
                this.chunkPosIterator = Utils.generateOutwardPositions(x, y, minSize, maxSize).iterator();
            }
        }

        public boolean hasNext() {
            return this.chunkPosIterator.hasNext();
        }

        public SearchResult next() {
            while (this.hasNext()) {
                if (++this.scannedChunks % 1000 == 0) {
                    Common.LOGGER.info("Scanned {} chunks", (Object)this.scannedChunks);
                }
                class_1923 position = this.chunkPosIterator.next();
                class_5138 structureManager = this.level.method_27056();
                for (Map.Entry<class_6872, Set<class_6880<class_3195>>> entry : this.placements.entrySet()) {
                    Pair<class_2338, class_6880<class_3195>> pair = ChunkGeneratorInvoker.invokeGetStructureGeneratingAt(entry.getValue(), (class_4538)this.level, structureManager, this.skipKnownStructures, (class_6874)entry.getKey(), position);
                    if (pair == null) continue;
                    return new SearchResult((class_2338)pair.getFirst(), (class_6880<class_3195>)((class_6880)pair.getSecond()));
                }
            }
            throw new NoSuchElementException("No more structures found");
        }
    }

    public record SearchResult(class_2338 pos, class_6880<class_3195> structure) {
    }
}

