/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_gateways.BlockEntityTypes;
import net.conczin.immersive_gateways.Sounds;
import net.conczin.immersive_gateways.block.GatewayBlock;
import net.conczin.immersive_gateways.block.GatewayExecutorController;
import net.conczin.immersive_gateways.data.PortalDataManager;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class GatewayBlockEntity
extends class_2586 {
    public static final double DISTANCE = 16.0;
    public static final int COOLDOWN = 30;
    public static final float OFFSET = 2.5f;
    public static Vector2f[] offsets = new Vector2f[]{new Vector2f(0.25f, 0.25f), new Vector2f(0.75f, 0.25f), new Vector2f(0.75f, 0.75f), new Vector2f(0.25f, 0.75f)};
    Vector3f[] offsets1;
    Vector3f[] offsets2;
    Quaternionf[] rotations;
    float[] lastTime = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    float[] time = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    boolean[] state = new boolean[]{false, false, false, false};
    Random random = new Random();
    int color = 0;
    static final Map<UUID, Long> lastCloseTick = new ConcurrentHashMap<UUID, Long>();

    private Vector3f[] getOffsets() {
        return this.getOffsets(new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)});
    }

    private float getRandom() {
        return this.random.nextFloat() * 2.0f - 1.0f;
    }

    private Vector3f offsetVector(Vector3f offset) {
        return new Vector3f(offset.x() + this.getRandom() * 2.5f, offset.y() + this.getRandom() * 2.5f, offset.z() + this.getRandom() * 2.5f);
    }

    private Vector3f[] getOffsets(Vector3f[] offset) {
        return new Vector3f[]{this.offsetVector(offset[0]), this.offsetVector(offset[1]), this.offsetVector(offset[2]), this.offsetVector(offset[3])};
    }

    public Quaternionf randomQuaternion() {
        float u1 = this.random.nextFloat();
        float u2 = this.random.nextFloat();
        float u3 = this.random.nextFloat();
        double theta1 = Math.PI * 2 * (double)u1;
        double theta2 = Math.PI * 2 * (double)u2;
        double s1 = Math.sqrt(1.0 - (double)u3);
        double s2 = Math.sqrt(u3);
        float x = (float)(s1 * Math.sin(theta1));
        float y = (float)(s1 * Math.cos(theta1));
        float z = (float)(s2 * Math.sin(theta2));
        float w = (float)(s2 * Math.cos(theta2));
        return new Quaternionf(x, y, z, w).normalize();
    }

    public GatewayBlockEntity(class_2338 pos, class_2680 blockState) {
        super(BlockEntityTypes.GATEWAY, pos, blockState);
        this.rotations = new Quaternionf[]{this.randomQuaternion(), this.randomQuaternion(), this.randomQuaternion(), this.randomQuaternion()};
        this.offsets1 = this.getOffsets();
        this.offsets2 = this.getOffsets(this.offsets1);
    }

    public Vector3d getPosition(class_2338 pos, class_2680 state, int i) {
        class_2350.class_2351 value = (class_2350.class_2351)state.method_11654(GatewayBlock.AXIS);
        return new Vector3d((double)((float)pos.method_10263() + (value == class_2350.class_2351.field_11048 ? GatewayBlockEntity.offsets[i].x : (value == class_2350.class_2351.field_11052 ? GatewayBlockEntity.offsets[i].x : 0.5f))), (double)((float)pos.method_10264() + (value == class_2350.class_2351.field_11048 ? GatewayBlockEntity.offsets[i].y : (value == class_2350.class_2351.field_11052 ? 0.5f : GatewayBlockEntity.offsets[i].y))), (double)((float)pos.method_10260() + (value == class_2350.class_2351.field_11048 ? 0.5f : (value == class_2350.class_2351.field_11052 ? GatewayBlockEntity.offsets[i].y : GatewayBlockEntity.offsets[i].x))));
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, GatewayBlockEntity blockEntity) {
        for (int i = 0; i < 4; ++i) {
            long time = level.method_8510();
            if ((time ^ (long)pos.method_10263() * 77L ^ (long)pos.method_10264() * 66L ^ (long)pos.method_10260() * 55L + (long)i * 44L) % 30L == 0L) {
                Vector3d position = blockEntity.getPosition(pos, state, i);
                class_1657 player = level.method_18459(position.x, position.y, position.z, 32.0, false);
                boolean isClose = false;
                if (player != null) {
                    double distance = player.method_5649(position.x, position.y, position.z);
                    if (distance < 256.0) {
                        lastCloseTick.put(player.method_5667(), time);
                    }
                    isClose = lastCloseTick.getOrDefault(player.method_5667(), 0L) + 30L > time;
                }
                blockEntity.state[i] = isClose;
            }
            blockEntity.lastTime[i] = blockEntity.time[i];
            blockEntity.time[i] = blockEntity.state[i] ? Math.min(1.0f, blockEntity.time[i] + 0.033333335f) : Math.max(0.0f, blockEntity.time[i] - 0.033333335f);
            float threshold = 0.75f;
            if (blockEntity.time[i] > threshold && blockEntity.lastTime[i] <= threshold) {
                GatewayBlockEntity.playSound(level, pos, Sounds.ASSEMBLE);
                continue;
            }
            if (!(blockEntity.time[i] <= threshold) || !(blockEntity.lastTime[i] > threshold)) continue;
            GatewayBlockEntity.playSound(level, pos, Sounds.DISASSEMBLE);
        }
    }

    public static void serverTick(class_3218 level, class_2338 pos, class_2680 state, GatewayBlockEntity blockEntity) {
        if (blockEntity.color == 0) {
            blockEntity.color = 1;
            PortalDataManager.PortalPair pair = PortalDataManager.search(level, pos);
            if (pair.first.resolved() && pair.second.resolved()) {
                GatewayBlockEntity.applyPortalColor(level, pos, blockEntity, pair);
            } else {
                GatewayExecutorController.submit(() -> {
                    PortalDataManager.PortalPair resolvedPair = PortalDataManager.searchAndResolve(level, pos);
                    GatewayBlockEntity.applyPortalColor(level, pos, blockEntity, resolvedPair);
                });
            }
        }
    }

    private static void applyPortalColor(class_3218 level, class_2338 pos, GatewayBlockEntity blockEntity, PortalDataManager.PortalPair pair) {
        blockEntity.setColor(pair.getTarget(pos).color());
        level.method_14178().method_14128(pos);
    }

    public void setColor(int color) {
        this.color = color;
        this.method_5431();
    }

    private static void playSound(class_1937 level, class_2338 pos, class_3414 sound) {
        float volume = level.field_9229.method_43057() * 0.1f + 0.1f;
        float pitch = level.field_9229.method_43057() * 0.4f + 0.8f;
        level.method_8396(null, pos, sound, class_3419.field_15245, volume, pitch);
    }

    public static void teleportEntity(class_3218 level, class_2338 pos, class_1297 entity) {
        GatewayBlockEntity.playSound((class_1937)level, pos, Sounds.GATEWAY);
        entity.method_30229();
        PortalDataManager.PortalPair pair = PortalDataManager.search(level, pos);
        PortalDataManager.Portal portal = pair.getTarget(pos);
        if (!portal.resolved()) {
            entity.method_43496((class_2561)class_2561.method_43471((String)"immersive_gateways.not_loaded_yet"));
            return;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6092(new class_1293(class_1294.field_5919, 50, 0));
        }
        class_2338 targetPos = portal.getSafePosition(level);
        double portalCenterX = (double)(portal.boundingBox().method_35418() + portal.boundingBox().method_35415()) / 2.0;
        double portalCenterZ = (double)(portal.boundingBox().method_35420() + portal.boundingBox().method_35417()) / 2.0;
        double deltaX = portalCenterX - ((double)targetPos.method_10263() + 0.5);
        double deltaZ = portalCenterZ - ((double)targetPos.method_10260() + 0.5);
        float targetYRot = (float)(Math.toDegrees(Math.atan2(-deltaZ, deltaX)) + 360.0) % 360.0f;
        targetYRot = Math.round(targetYRot / 90.0f) * 90;
        double targetX = (double)targetPos.method_10263() + 0.5;
        double targetY = targetPos.method_10264();
        double targetZ = (double)targetPos.method_10260() + 0.5;
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            serverPlayer.method_14251(level, targetX, targetY, targetZ, targetYRot, serverPlayer.method_36455());
            serverPlayer.method_5847(targetYRot);
            serverPlayer.field_6259 = targetYRot;
        } else {
            entity.method_20620(targetX, targetY, targetZ);
            entity.method_36456(targetYRot);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (this.field_11863 instanceof class_638) {
            this.color = tag.method_10550("Color");
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10566("Color", (class_2520)class_2497.method_23247((int)this.color));
        return tag;
    }

    public int getColor() {
        return this.color;
    }
}

