/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.block;

import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.IrisCompat;
import net.conczin.immersive_gateways.Utils;
import net.conczin.immersive_gateways.block.GatewayBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_840;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GatewayBlockEntityRenderer<T extends GatewayBlockEntity>
implements class_827<T> {
    public static final class_2960 BLANK_LOCATION = Common.locate("textures/entity/white.png");
    public static final Vector3f[] NORMALS = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};

    public GatewayBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 0);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 1);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 2);
        this.renderRuneCube(blockEntity, partialTick, poseStack, buffer, packedLight, packedOverlay, 3);
    }

    private void renderRuneCube(T blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, int face) {
        class_2338 blockPos = blockEntity.method_11016();
        Vector3d position = ((GatewayBlockEntity)((Object)blockEntity)).getPosition(blockPos, blockEntity.method_11010(), face);
        float blinkDuration = 0.2f;
        float f = ((GatewayBlockEntity)((Object)blockEntity)).lastTime[face] * (1.0f - partialTick) + ((GatewayBlockEntity)((Object)blockEntity)).time[face] * partialTick;
        float f2 = 1.0f - Math.min((float)1.0f, (float)(f / (1.0f - blinkDuration)));
        if ((double)f <= 0.0) {
            return;
        }
        Vector3f offset = Utils.calculateQuadraticBezier(new Vector3f(0.0f, 0.0f, 0.0f), ((GatewayBlockEntity)((Object)blockEntity)).offsets1[face], ((GatewayBlockEntity)((Object)blockEntity)).offsets2[face], f2);
        Quaternionf rotation = new Quaternionf();
        rotation.slerp((Quaternionfc)((GatewayBlockEntity)((Object)blockEntity)).rotations[face], f2);
        float size = 0.25f * Math.sqrt((float)f);
        float brightness = Math.max((float)0.0f, (float)(1.0f - Math.abs((float)(1.0f - blinkDuration - f)) / blinkDuration));
        poseStack.method_22903();
        poseStack.method_22904(position.x - (double)blockPos.method_10263() + (double)offset.x, position.y - (double)blockPos.method_10264() + (double)offset.y, position.z - (double)blockPos.method_10260() + (double)offset.z);
        poseStack.method_22907(rotation);
        poseStack.method_22905(size, size, size);
        if (IrisCompat.isShaderPackInUse()) {
            this.renderCubeIris((GatewayBlockEntity)((Object)blockEntity), partialTick, poseStack, buffer, packedLight, packedOverlay, ((GatewayBlockEntity)((Object)blockEntity)).getColor());
        } else {
            this.renderCube(poseStack.method_23760(), buffer.getBuffer(class_1921.method_34571()));
            this.renderCube(poseStack.method_23760(), buffer.getBuffer(class_1921.method_42600((class_2960)BLANK_LOCATION)), packedLight, packedOverlay, brightness, ((GatewayBlockEntity)((Object)blockEntity)).getColor());
        }
        poseStack.method_22909();
    }

    private void renderCube(class_4587.class_4665 pose, class_4588 consumer) {
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f);
        this.renderFace(pose, consumer, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        this.renderFace(pose, consumer, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f);
    }

    private void renderCube(class_4587.class_4665 pose, class_4588 consumer, int light, int overlay, float brightness, int color) {
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1, light, overlay, brightness, color);
        this.renderFace(pose, consumer, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 2, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 3, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 4, light, overlay, brightness, color);
        this.renderFace(pose, consumer, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 5, light, overlay, brightness, color);
    }

    private void renderFace(class_4587.class_4665 pose, class_4588 consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3) {
        consumer.method_22918(pose.method_23761(), x0, y0, z0).method_1344();
        consumer.method_22918(pose.method_23761(), x1, y0, z1).method_1344();
        consumer.method_22918(pose.method_23761(), x1, y1, z2).method_1344();
        consumer.method_22918(pose.method_23761(), x0, y1, z3).method_1344();
    }

    private void renderFace(class_4587.class_4665 pose, class_4588 consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, int face, int light, int overlay, float brightness, int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float a = 0.15f + 0.25f * brightness;
        float u = Math.floor((float)((float)face / 2.0f)) * 6.0f;
        float v = (float)face % 2.0f * 6.0f;
        Vector4f p = new Vector4f();
        Vector3f n = pose.method_23762().transform(new Vector3f((Vector3fc)NORMALS[face]));
        pose.method_23761().transform(x0, y0, z0, 1.0f, p);
        consumer.method_23919(p.x(), p.y(), p.z(), r, g, b, a, u / 32.0f, v / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.method_23761().transform(x1, y0, z1, 1.0f, p);
        consumer.method_23919(p.x(), p.y(), p.z(), r, g, b, a, (u + 6.0f) / 32.0f, v / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.method_23761().transform(x1, y1, z2, 1.0f, p);
        consumer.method_23919(p.x(), p.y(), p.z(), r, g, b, a, (u + 6.0f) / 32.0f, (v + 6.0f) / 32.0f, overlay, light, n.x(), n.y(), n.z());
        pose.method_23761().transform(x0, y1, z3, 1.0f, p);
        consumer.method_23919(p.x(), p.y(), p.z(), r, g, b, a, u / 32.0f, (v + 6.0f) / 32.0f, overlay, light, n.x(), n.y(), n.z());
    }

    public void renderCubeIris(GatewayBlockEntity entity, float tickDelta, class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay, int color) {
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23572((class_2960)class_840.field_4407));
        Matrix4f pose = poseStack.method_23760().method_23761();
        Matrix3f normal = poseStack.method_23760().method_23762();
        float progress = (entity.method_10997() == null ? 0.0f : (float)entity.method_10997().method_8532() + tickDelta) * 0.05f * 0.01f % 1.0f;
        float topHeight = 1.0f;
        float bottomHeight = -1.0f;
        this.quad(vertexConsumer, pose, normal, class_2350.field_11036, progress, overlay, light, -1.0f, topHeight, 1.0f, 1.0f, topHeight, 1.0f, 1.0f, topHeight, -1.0f, -1.0f, topHeight, -1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, class_2350.field_11033, progress, overlay, light, -1.0f, bottomHeight, 1.0f, -1.0f, bottomHeight, -1.0f, 1.0f, bottomHeight, -1.0f, 1.0f, bottomHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, class_2350.field_11043, progress, overlay, light, -1.0f, topHeight, -1.0f, 1.0f, topHeight, -1.0f, 1.0f, bottomHeight, -1.0f, -1.0f, bottomHeight, -1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, class_2350.field_11039, progress, overlay, light, -1.0f, topHeight, 1.0f, -1.0f, topHeight, -1.0f, -1.0f, bottomHeight, -1.0f, -1.0f, bottomHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, class_2350.field_11035, progress, overlay, light, -1.0f, topHeight, 1.0f, -1.0f, bottomHeight, 1.0f, 1.0f, bottomHeight, 1.0f, 1.0f, topHeight, 1.0f, r, g, b);
        this.quad(vertexConsumer, pose, normal, class_2350.field_11034, progress, overlay, light, 1.0f, topHeight, 1.0f, 1.0f, bottomHeight, 1.0f, 1.0f, bottomHeight, -1.0f, 1.0f, topHeight, -1.0f, r, g, b);
    }

    private void quad(class_4588 vertexConsumer, Matrix4f pose, Matrix3f normal, class_2350 direction, float progress, int overlay, int light, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b) {
        float nx = direction.method_10148();
        float ny = direction.method_10164();
        float nz = direction.method_10165();
        vertexConsumer.method_22918(pose, x1, y1, z1).method_22915(r, g, b, 1.0f).method_22913(0.0f + progress, 0.0f + progress).method_22922(overlay).method_22916(light).method_23763(normal, nx, ny, nz).method_1344();
        vertexConsumer.method_22918(pose, x2, y2, z2).method_22915(r, g, b, 1.0f).method_22913(0.0f + progress, 0.1f + progress).method_22922(overlay).method_22916(light).method_23763(normal, nx, ny, nz).method_1344();
        vertexConsumer.method_22918(pose, x3, y3, z3).method_22915(r, g, b, 1.0f).method_22913(0.1f + progress, 0.1f + progress).method_22922(overlay).method_22916(light).method_23763(normal, nx, ny, nz).method_1344();
        vertexConsumer.method_22918(pose, x4, y4, z4).method_22915(r, g, b, 1.0f).method_22913(0.1f + progress, 0.0f + progress).method_22922(overlay).method_22916(light).method_23763(normal, nx, ny, nz).method_1344();
    }
}

