/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_gateways.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.conczin.immersive_gateways.Blocks;
import net.conczin.immersive_gateways.Common;
import net.conczin.immersive_gateways.Utils;
import net.conczin.immersive_gateways.config.Config;
import net.minecraft.class_18;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.apache.logging.log4j.Logger;

public class PortalDataManager {
    public static long toLong(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static PortalDataLookup getState(class_3218 level) {
        return (PortalDataLookup)level.method_17983().method_17924(PortalDataLookup::load, PortalDataLookup::new, "immersive_gateways");
    }

    public static synchronized PortalPair search(class_3218 level, class_2338 pos) {
        PortalDataLookup state = PortalDataManager.getState(level);
        PortalPair portal = state.search(pos);
        if (portal == null) {
            Config c = Config.getInstance();
            float distance = level.field_9229.method_43057() * (float)(c.maxDistance - c.minDistance) + (float)c.minDistance;
            double angle = (double)level.field_9229.method_43057() * Math.PI;
            class_2338 target = new class_2338((int)((double)pos.method_10263() + Math.cos(angle) * (double)distance), pos.method_10264(), (int)((double)pos.method_10260() + Math.sin(angle) * (double)distance));
            portal = new PortalPair(new Portal(PortalDataManager.findPortalBoundingBox(level, pos), PortalDataManager.getColor(level, pos), true), new Portal(class_3341.method_34390((class_2382)target, (class_2382)target), -1, false));
            state.add(portal);
            Common.LOGGER.info("New draft portal created.");
        }
        return portal;
    }

    public static PortalPair searchAndResolve(class_3218 level, class_2338 pos) {
        PortalDataLookup state = PortalDataManager.getState(level);
        PortalPair portal = PortalDataManager.search(level, pos);
        if (!portal.second.resolved()) {
            portal.second = PortalDataManager.resolve(state, portal.second, level);
            state.add(portal);
        }
        if (!portal.second.resolved()) {
            portal.second = PortalDataManager.resolve(state, portal.second, level);
            state.add(portal);
        }
        return portal;
    }

    private static Portal resolve(PortalDataLookup state, Portal portal, class_3218 level) {
        class_2338 target = portal.boundingBox().method_22874();
        Config c = Config.getInstance();
        Utils.NearestMapStructureIterator structures = Utils.getStructureSet(level, Common.locate("portal")).map(s -> new Utils.NearestMapStructureIterator(level, (class_6885<class_3195>)s, target, 0, c.maxScanDistanceInChunks, false)).orElse(null);
        if (structures == null) {
            Common.LOGGER.warn("No portal structures found.");
            return portal.resolve();
        }
        class_2338 candidate = null;
        while (structures.hasNext()) {
            Utils.SearchResult result = structures.next();
            if (state.search(result.pos()) != null) continue;
            candidate = result.pos();
            break;
        }
        if (candidate == null) {
            Common.LOGGER.warn("No nearby portal not found, giving up.");
            return portal.resolve();
        }
        class_3341 boundingBox = PortalDataManager.findPortalBoundingBox(level, candidate);
        return new Portal(boundingBox, PortalDataManager.getColor(level, candidate), true);
    }

    private static class_3341 estimateBoundingBox(class_3218 level, class_2338 pos) {
        int minX = pos.method_10263();
        int minY = pos.method_10264();
        int minZ = pos.method_10260();
        int maxX = pos.method_10263();
        int maxY = pos.method_10264();
        int maxZ = pos.method_10260();
        HashSet<class_2338> open = new HashSet<class_2338>();
        HashSet<class_2338> closed = new HashSet<class_2338>();
        open.add(pos);
        closed.add(pos);
        while (!open.isEmpty()) {
            class_2338 current = (class_2338)open.iterator().next();
            open.remove(current);
            if (!level.method_8320(current).method_27852(Blocks.GATEWAY)) continue;
            minX = Math.min(minX, current.method_10263());
            minY = Math.min(minY, current.method_10264());
            minZ = Math.min(minZ, current.method_10260());
            maxX = Math.max(maxX, current.method_10263());
            maxY = Math.max(maxY, current.method_10264());
            maxZ = Math.max(maxZ, current.method_10260());
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 neighbor = current.method_10069(x, y, z);
                        if (closed.contains(neighbor)) continue;
                        open.add(neighbor);
                        closed.add(neighbor);
                    }
                }
            }
        }
        return new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static class_3341 findPortalBoundingBox(class_3218 level, class_2338 pos) {
        long time = System.nanoTime();
        class_2338 improvedPos = PortalDataManager.findBlockInArea(level, pos);
        if (improvedPos == null) {
            Common.LOGGER.warn("Failed to find gateway block near {}.", (Object)pos);
            return class_3341.method_34390((class_2382)pos, (class_2382)pos);
        }
        class_3341 boundingBox = PortalDataManager.estimateBoundingBox(level, improvedPos);
        long delta = System.nanoTime() - time;
        Common.LOGGER.info("Exit search took {} ms.", (Object)(delta / 1000000L));
        return boundingBox;
    }

    private static class_2338 findBlockInArea(class_3218 level, class_2338 pos) {
        class_2338.class_2339 gatewayPos = new class_2338.class_2339();
        int centerCx = class_4076.method_18675((int)pos.method_10263());
        int centerCz = class_4076.method_18675((int)pos.method_10260());
        for (int[] coord : Utils.chunkCoordsInRadiusSorted(centerCx, centerCz, 3)) {
            int cx = coord[0];
            int cz = coord[1];
            class_2818 chunk = level.method_8497(cx, cz);
            for (int cy = 0; cy < chunk.method_32890(); ++cy) {
                class_2826 section = chunk.method_38259(cy);
                if (section.method_38292() || !section.method_19523(s -> s.method_27852(Blocks.GATEWAY))) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            gatewayPos.method_10103(class_4076.method_32205((int)cx, (int)x), class_4076.method_32205((int)chunk.method_31604(cy), (int)y), class_4076.method_32205((int)cz, (int)z));
                            if (!chunk.method_8320((class_2338)gatewayPos).method_27852(Blocks.GATEWAY)) continue;
                            return gatewayPos;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static int getColor(class_3218 level, class_2338 pos) {
        class_6880 biome = level.method_23753(pos);
        class_2960 resourceLocation = biome.method_40230().map(class_5321::method_29177).orElse(new class_2960("minecraft:plains"));
        if (!Config.getInstance().colors.containsKey(resourceLocation.toString())) {
            Common.LOGGER.info("Biome {} not found in color config, using default foliage color.", (Object)resourceLocation);
        }
        return Config.getInstance().colors.getOrDefault(resourceLocation.toString(), ((class_1959)biome.comp_349()).method_8698());
    }

    public static class PortalDataLookup
    extends class_18 {
        final Set<PortalPair> portals = new HashSet<PortalPair>();
        final Map<Long, Set<PortalPair>> lookup = new HashMap<Long, Set<PortalPair>>();

        public static PortalDataLookup load(class_2487 nbt) {
            PortalDataLookup c = new PortalDataLookup();
            for (String key : nbt.method_10541()) {
                PortalPair pair = PortalPair.load(nbt.method_10580(key));
                c.portals.add(pair);
                c.populateLookup(pair);
            }
            return c;
        }

        public class_2487 method_75(class_2487 nbt) {
            int index = 0;
            for (PortalPair pair : this.portals) {
                nbt.method_10566(String.valueOf(index), pair.save());
                ++index;
            }
            return nbt;
        }

        public synchronized void add(PortalPair data) {
            this.portals.add(data);
            this.populateLookup(data);
            this.method_80();
        }

        private void populateLookup(PortalPair data) {
            this.populateLookup(data, data.first);
            this.populateLookup(data, data.second);
        }

        private void populateLookup(PortalPair data, Portal portal) {
            int minX = portal.boundingBox().method_35415() >> 4;
            int minZ = portal.boundingBox().method_35417() >> 4;
            int maxX = portal.boundingBox().method_35418() >> 4;
            int maxZ = portal.boundingBox().method_35420() >> 4;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    long cellId = PortalDataManager.toLong(x, z);
                    this.lookup.computeIfAbsent(cellId, k -> new HashSet()).add(data);
                }
            }
        }

        public PortalPair search(class_2338 pos) {
            int cz;
            int cx = pos.method_10263() >> 4;
            long cellId = PortalDataManager.toLong(cx, cz = pos.method_10260() >> 4);
            Set<PortalPair> candidates = this.lookup.get(cellId);
            if (candidates != null) {
                for (PortalPair candidate : candidates) {
                    if (!candidate.first.boundingBox().method_14662((class_2382)pos) && !candidate.second.boundingBox().method_14662((class_2382)pos)) continue;
                    return candidate;
                }
            }
            return null;
        }
    }

    public static final class PortalPair {
        public static final Codec<PortalPair> CODEC = RecordCodecBuilder.create(pair -> pair.group((App)Portal.CODEC.fieldOf("first").forGetter(PortalPair::first), (App)Portal.CODEC.fieldOf("second").forGetter(PortalPair::second)).apply((Applicative)pair, PortalPair::new));
        public Portal first;
        public Portal second;

        public PortalPair(Portal first, Portal second) {
            this.first = first;
            this.second = second;
        }

        public static PortalPair load(class_2520 nbt) {
            return (PortalPair)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)Common.LOGGER).error(arg_0)).orElseThrow();
        }

        public class_2520 save() {
            return (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).resultOrPartial(arg_0 -> ((Logger)Common.LOGGER).error(arg_0)).orElseThrow();
        }

        public Portal first() {
            return this.first;
        }

        public Portal second() {
            return this.second;
        }

        public Portal getTarget(class_2338 pos) {
            double dist2;
            double dist1 = this.first.boundingBox.method_22874().method_10262((class_2382)pos);
            return dist1 < (dist2 = this.second.boundingBox.method_22874().method_10262((class_2382)pos)) ? this.second : this.first;
        }
    }

    public record Portal(class_3341 boundingBox, int color, boolean resolved) {
        public static final Codec<Portal> CODEC = RecordCodecBuilder.create(portal -> portal.group((App)class_3341.field_29325.fieldOf("boundingBox").forGetter(Portal::boundingBox), (App)Codec.INT.fieldOf("color").forGetter(Portal::color), (App)Codec.BOOL.fieldOf("resolved").forGetter(Portal::resolved)).apply((Applicative)portal, Portal::new));

        public Portal resolve() {
            return new Portal(this.boundingBox, this.color, true);
        }

        public class_2338 getSafePosition(class_3218 level) {
            LinkedList<class_2338> candidates = new LinkedList<class_2338>();
            if (this.boundingBox.method_14663() > 1) {
                int z = (this.boundingBox.method_35417() + this.boundingBox.method_35420()) / 2;
                candidates.add(new class_2338(this.boundingBox.method_35415() - 1, this.boundingBox.method_35416(), z));
                candidates.add(new class_2338(this.boundingBox.method_35418() + 1, this.boundingBox.method_35416(), z));
            }
            if (this.boundingBox.method_35414() > 1) {
                int x = (this.boundingBox.method_35415() + this.boundingBox.method_35418()) / 2;
                candidates.add(new class_2338(x, this.boundingBox.method_35416(), this.boundingBox.method_35417() - 1));
                candidates.add(new class_2338(x, this.boundingBox.method_35416(), this.boundingBox.method_35420() + 1));
            }
            for (int y = this.boundingBox.method_35416(); y <= level.method_31600(); ++y) {
                for (class_2338 candidate : candidates) {
                    class_2338 pos = new class_2338(candidate.method_10263(), y, candidate.method_10260());
                    if (!level.method_8320(pos).method_26215() || !level.method_8320(pos.method_10069(0, 1, 0)).method_26215()) continue;
                    return pos;
                }
            }
            return this.boundingBox.method_22874();
        }
    }
}

