/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.client;

import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.xiyu.spartanshieldsunofficial.client.model.DarkSteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ElementiumTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.EnderiumShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.KiteShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.LumiumShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ManasteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.MekanismTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ShieldBaseModel;
import org.xiyu.spartanshieldsunofficial.client.model.TerrasteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.TowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.render.item.ModelLayers;
import org.xiyu.spartanshieldsunofficial.client.render.item.TowerShieldBEWLR;
import org.xiyu.spartanshieldsunofficial.init.ModDataComponents;
import org.xiyu.spartanshieldsunofficial.init.ModItems;
import org.xiyu.spartanshieldsunofficial.item.FEPoweredShieldItem;
import org.xiyu.spartanshieldsunofficial.item.ShieldBaseItem;
import org.xiyu.spartanshieldsunofficial.util.Log;

@EventBusSubscriber(modid="spartanshieldsunofficial", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHelper {
    public static void registerShieldPropertyOverrides(ShieldBaseItem item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"blocking"), (stack, world, living, value) -> living != null && living.isUsingItem() && living.getUseItem() == stack ? 1.0f : 0.0f);
    }

    public static void registerPoweredShieldPropertyOverrides(FEPoweredShieldItem item) {
        ClientHelper.registerShieldPropertyOverrides(item);
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"disabled"), (stack, world, living, value) -> {
            boolean disabled = (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.STORED_ENERGY.get(), (Object)0) <= 0;
            return disabled ? 1.0f : 0.0f;
        });
    }

    @SubscribeEvent
    public static void registerItemColours(RegisterColorHandlersEvent.Item ev) {
        ev.register(new ItemColor(){

            public int getColor(ItemStack stack, int layer) {
                return layer == 1 ? -8851325 : -1;
            }
        }, new ItemLike[]{(ItemLike)ModItems.BASIC_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int getColor(ItemStack stack, int layer) {
                return layer == 1 ? -1017725 : -1;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ADVANCED_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int getColor(ItemStack stack, int layer) {
                return layer == 1 ? -8879120 : -1;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ELITE_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int getColor(ItemStack stack, int layer) {
                return layer == 1 ? -1014800 : -1;
            }
        }, new ItemLike[]{(ItemLike)ModItems.ULTIMATE_MEKANISTS_BASIC_SHIELD.get()});
        ev.register(new ItemColor(){

            public int getColor(ItemStack stack, int layer) {
                return layer == 1 ? -8323168 : -1;
            }
        }, new ItemLike[]{(ItemLike)ModItems.DARK_STEEL_RIOT_BASIC_SHIELD.get()});
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions ev) {
        Log.info("Registering Model Layers!");
        ev.registerLayerDefinition(ModelLayers.BASE_SHIELD, ShieldBaseModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.KITE_SHIELD, KiteShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.TOWER_SHIELD, TowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.LUMIUM_SHIELD, LumiumShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.ENDERIUM_SHIELD, EnderiumShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MANASTEEL_SHIELD, ManasteelTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.TERRASTEEL_SHIELD, TerrasteelTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.ELEMENTIUM_SHIELD, ElementiumTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.MEKANISM_SHIELD, MekanismTowerShieldModel::createLayer);
        ev.registerLayerDefinition(ModelLayers.DARK_STEEL_SHIELD, DarkSteelTowerShieldModel::createLayer);
        Log.info("Model Layer registration complete!");
    }

    @SubscribeEvent
    public static void reloadClient(RegisterClientReloadListenersEvent ev) {
        ev.registerReloadListener((PreparableReloadListener)TowerShieldBEWLR.INSTANCE);
    }
}

