/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.xiyu.spartanshieldsunofficial.client.model.ShieldBaseModel;

public class DarkSteelTowerShieldModel
extends ShieldBaseModel {
    protected static final String PART_PLATE_EXTRA = "plate_extra";
    protected static final String PART_UPPER = "plate_upper";
    protected static final String PART_LOWER = "plate_lower";
    public ModelPart plateExtra;
    public ModelPart upper;
    public ModelPart lower;
    private final ImmutableList<ModelPart> extraParts;

    public DarkSteelTowerShieldModel(ModelPart rootModel) {
        super(RenderType::entityTranslucent, rootModel);
        this.plateExtra = rootModel.getChild(PART_PLATE_EXTRA);
        this.upper = rootModel.getChild(PART_UPPER);
        this.lower = rootModel.getChild(PART_LOWER);
        this.extraParts = ImmutableList.of((Object)this.plateExtra, (Object)this.upper, (Object)this.lower);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition platePart = part.addOrReplaceChild("plate", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -7.0f, -2.0f, 12.0f, 17.0f, 1.0f), PartPose.ZERO);
        part.addOrReplaceChild("handle", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 6.0f), PartPose.ZERO);
        platePart.addOrReplaceChild("plate_lower_main", CubeListBuilder.create().texOffs(0, 17).addBox(-6.0f, 0.0f, 0.0f, 12.0f, 5.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(PART_PLATE_EXTRA, CubeListBuilder.create().texOffs(50, 9).addBox(6.0f, -7.0f, -2.5f, 2.0f, 16.0f, 2.0f).texOffs(42, 9).addBox(-8.0f, -7.0f, -2.5f, 2.0f, 16.0f, 2.0f), PartPose.ZERO);
        part.addOrReplaceChild(PART_UPPER, CubeListBuilder.create().texOffs(16, 24).addBox(-4.0f, -7.0f, 0.0f, 8.0f, 1.0f, 1.0f).texOffs(0, 24).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 2.0f).texOffs(42, 0).addBox(-7.9f, -7.0f, -0.5f, 2.0f, 7.0f, 2.0f).texOffs(50, 0).addBox(5.9f, -7.0f, -0.5f, 2.0f, 7.0f, 2.0f).texOffs(12, 26).addBox(-6.0f, -6.0f, 0.0f, 12.0f, 6.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        part.addOrReplaceChild(PART_LOWER, CubeListBuilder.create().texOffs(42, 27).addBox(-7.9f, -1.0f, -0.1f, 2.0f, 5.0f, 2.0f).texOffs(50, 27).addBox(5.9f, -1.0f, -0.1f, 2.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public void renderExtraParts(PoseStack mStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, int color) {
        super.renderExtraParts(mStack, vertexBuilder, packedLightIn, packedOverlayIn, color);
        this.extraParts.forEach(model -> model.render(mStack, vertexBuilder, packedLightIn, packedOverlayIn, color));
    }

    @Override
    public void renderLayers(PoseStack mStack, MultiBufferSource bufferIn, RenderType renderTypeIn, int packedLightIn, int packedOverlayIn, int color) {
        VertexConsumer consumer = bufferIn.getBuffer(renderTypeIn);
        this.root.render(mStack, consumer, packedLightIn, packedOverlayIn, color);
    }
}

