/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ShieldBaseModel
extends Model {
    protected static final String PART_PLATE = "plate";
    protected static final String PART_HANDLE = "handle";
    protected ModelPart root;
    protected ModelPart plate;
    protected ModelPart handle;

    public ShieldBaseModel(Function<ResourceLocation, RenderType> renderType, ModelPart rootModel) {
        super(renderType);
        this.root = rootModel;
        this.plate = rootModel.getChild(PART_PLATE);
        this.handle = rootModel.getChild(PART_HANDLE);
    }

    public ShieldBaseModel(ModelPart rootModel) {
        this(RenderType::entitySolid, rootModel);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        part.addOrReplaceChild(PART_PLATE, CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -11.0f, -2.0f, 12.0f, 22.0f, 1.0f), PartPose.ZERO);
        part.addOrReplaceChild(PART_HANDLE, CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 6.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart getPlate() {
        return this.plate;
    }

    public void renderExtraParts(PoseStack mStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, int color) {
        this.handle.render(mStack, vertexBuilder, packedLightIn, packedOverlayIn, color);
    }

    public void renderLayers(PoseStack mStack, MultiBufferSource bufferIn, RenderType renderTypeIn, int packedLightIn, int packedOverlayIn, int color) {
    }

    public void renderToBuffer(PoseStack mStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, int color) {
        this.root.render(mStack, vertexBuilder, packedLightIn, packedOverlayIn, color);
    }
}

