/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.client.render.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.xiyu.spartanshieldsunofficial.client.model.DarkSteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ElementiumTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.EnderiumShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.KiteShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.LumiumShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ManasteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.MekanismTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.ShieldBaseModel;
import org.xiyu.spartanshieldsunofficial.client.model.TerrasteelTowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.model.TowerShieldModel;
import org.xiyu.spartanshieldsunofficial.client.render.item.ModelLayers;
import org.xiyu.spartanshieldsunofficial.client.render.item.TextureStitcher;
import org.xiyu.spartanshieldsunofficial.client.render.item.TowerShieldRenderInfo;
import org.xiyu.spartanshieldsunofficial.init.ModItems;

public class TowerShieldBEWLR
extends BlockEntityWithoutLevelRenderer
implements ResourceManagerReloadListener {
    public static final TowerShieldBEWLR INSTANCE = new TowerShieldBEWLR();
    private ShieldBaseModel baseShield;
    private ShieldBaseModel kiteShield;
    private ShieldBaseModel towerShield;
    private ShieldBaseModel lumiumShield;
    private ShieldBaseModel enderiumShield;
    private ShieldBaseModel manasteelShield;
    private ShieldBaseModel terrasteelShield;
    private ShieldBaseModel elementiumShield;
    private ShieldBaseModel mekanismShield;
    private ShieldBaseModel darkSteelShield;
    private Map<Item, ShieldBaseModel> modelMap;
    private Map<Item, TowerShieldRenderInfo> renderInfoMap;

    private TowerShieldBEWLR() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        ImmutableMap.Builder renderInfoMapBuilder = ImmutableMap.builder();
        renderInfoMapBuilder.put((Object)((Item)ModItems.WOODEN_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_WOODEN_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.STONE_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_STONE_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.COPPER_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_COPPER_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.IRON_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_IRON_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.GOLDEN_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_GOLDEN_TOWER_SHIELD_);
        renderInfoMapBuilder.put((Object)((Item)ModItems.DIAMOND_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_DIAMOND_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.NETHERITE_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_NETHERITE_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.OBSIDIAN_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_OBSIDIAN_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.TIN_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_TIN_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.BRONZE_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_BRONZE_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.STEEL_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_STEEL_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.SILVER_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_SILVER_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ELECTRUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ELECTRUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.LEAD_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_LEAD_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.NICKEL_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_NICKEL_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.INVAR_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_INVAR_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.CONSTANTAN_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_CONSTANTAN_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.PLATINUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_PLATINUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ALUMINUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ALUMINUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.SIGNALUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_SIGNALUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.LUMIUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_LUMIUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ENDERIUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ENDERIUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.MANASTEEL_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_MANASTEEL_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.TERRASTEEL_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_TERRASTEEL_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ELEMENTIUM_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ELEMENTIUM_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.BASIC_MEKANISTS_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_BASIC_MEKANISTS_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ADVANCED_MEKANISTS_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ELITE_MEKANISTS_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ELITE_MEKANISTS_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.ULTIMATE_MEKANISTS_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_ULTIMATE_MEKANISTS_TOWER_SHIELD);
        renderInfoMapBuilder.put((Object)((Item)ModItems.DARK_STEEL_RIOT_TOWER_SHIELD.get()), (Object)TextureStitcher.RENDER_INFO_DARK_STEEL_TOWER_SHIELD);
        this.renderInfoMap = renderInfoMapBuilder.build();
    }

    public void onResourceManagerReload(ResourceManager p_172555_) {
        Minecraft mc = Minecraft.getInstance();
        this.baseShield = new ShieldBaseModel(mc.getEntityModels().bakeLayer(ModelLayers.BASE_SHIELD));
        this.kiteShield = new KiteShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.KITE_SHIELD));
        this.towerShield = new TowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.TOWER_SHIELD));
        this.lumiumShield = new LumiumShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.LUMIUM_SHIELD));
        this.enderiumShield = new EnderiumShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.ENDERIUM_SHIELD));
        this.manasteelShield = new ManasteelTowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.MANASTEEL_SHIELD));
        this.terrasteelShield = new TerrasteelTowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.TERRASTEEL_SHIELD));
        this.elementiumShield = new ElementiumTowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.ELEMENTIUM_SHIELD));
        this.mekanismShield = new MekanismTowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.MEKANISM_SHIELD));
        this.darkSteelShield = new DarkSteelTowerShieldModel(mc.getEntityModels().bakeLayer(ModelLayers.DARK_STEEL_SHIELD));
        ImmutableMap.Builder modelMapBuilder = ImmutableMap.builder();
        modelMapBuilder.put((Object)((Item)ModItems.WOODEN_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.STONE_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.COPPER_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.IRON_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.GOLDEN_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.DIAMOND_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.NETHERITE_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.OBSIDIAN_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.TIN_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.BRONZE_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.STEEL_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.SILVER_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.ELECTRUM_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.LEAD_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.NICKEL_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.INVAR_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.CONSTANTAN_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.PLATINUM_TOWER_SHIELD.get()), (Object)this.kiteShield);
        modelMapBuilder.put((Object)((Item)ModItems.ALUMINUM_TOWER_SHIELD.get()), (Object)this.baseShield);
        modelMapBuilder.put((Object)((Item)ModItems.SIGNALUM_TOWER_SHIELD.get()), (Object)this.towerShield);
        modelMapBuilder.put((Object)((Item)ModItems.LUMIUM_TOWER_SHIELD.get()), (Object)this.lumiumShield);
        modelMapBuilder.put((Object)((Item)ModItems.ENDERIUM_TOWER_SHIELD.get()), (Object)this.enderiumShield);
        modelMapBuilder.put((Object)((Item)ModItems.MANASTEEL_TOWER_SHIELD.get()), (Object)this.manasteelShield);
        modelMapBuilder.put((Object)((Item)ModItems.TERRASTEEL_TOWER_SHIELD.get()), (Object)this.terrasteelShield);
        modelMapBuilder.put((Object)((Item)ModItems.ELEMENTIUM_TOWER_SHIELD.get()), (Object)this.elementiumShield);
        modelMapBuilder.put((Object)((Item)ModItems.BASIC_MEKANISTS_TOWER_SHIELD.get()), (Object)this.mekanismShield);
        modelMapBuilder.put((Object)((Item)ModItems.ADVANCED_MEKANISTS_TOWER_SHIELD.get()), (Object)this.mekanismShield);
        modelMapBuilder.put((Object)((Item)ModItems.ELITE_MEKANISTS_TOWER_SHIELD.get()), (Object)this.mekanismShield);
        modelMapBuilder.put((Object)((Item)ModItems.ULTIMATE_MEKANISTS_TOWER_SHIELD.get()), (Object)this.mekanismShield);
        modelMapBuilder.put((Object)((Item)ModItems.DARK_STEEL_RIOT_TOWER_SHIELD.get()), (Object)this.darkSteelShield);
        this.modelMap = modelMapBuilder.build();
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack mStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ShieldBaseModel model = this.modelMap.get(stack.getItem());
        TowerShieldRenderInfo renderInfo = this.renderInfoMap.get(stack.getItem());
        if (model != null && renderInfo != null) {
            BannerPatternLayers bannerPatterns = (BannerPatternLayers)stack.get(DataComponents.BANNER_PATTERNS);
            DyeColor baseColor = (DyeColor)stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.WHITE);
            boolean isBannered = bannerPatterns != null && !bannerPatterns.layers().isEmpty();
            mStack.pushPose();
            mStack.scale(1.0f, -1.0f, -1.0f);
            Material material = renderInfo.getMaterial(isBannered);
            VertexConsumer consumer = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)model.renderType(material.atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            model.renderExtraParts(mStack, consumer, packedLight, packedOverlay, -1);
            if (isBannered) {
                BannerRenderer.renderPatterns((PoseStack)mStack, (MultiBufferSource)buffer, (int)packedLight, (int)packedOverlay, (ModelPart)model.getPlate(), (Material)material, (boolean)false, (DyeColor)baseColor, (BannerPatternLayers)bannerPatterns);
            } else {
                model.getPlate().render(mStack, consumer, packedLight, packedOverlay, -1);
            }
            if (renderInfo.hasLayers()) {
                int color = 0xFF000000 | (int)(renderInfo.getColourRed() * 255.0f) << 16 | (int)(renderInfo.getColourGreen() * 255.0f) << 8 | (int)(renderInfo.getColourBlue() * 255.0f);
                model.renderLayers(mStack, buffer, renderInfo.getLayerRenderType(stack), packedLight, packedOverlay, color);
            }
            mStack.popPose();
        }
    }
}

