/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.crafting.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.conditions.ICondition;

public class TypeDisabledCondition
implements ICondition {
    public static final List<String> disabledRecipeTypes = new ArrayList<String>();
    public static final String MODDED = "modded";
    public static final String OBSIDIAN = "obsidian";
    public static final String COPPER = "copper";
    public static final String TIN = "tin";
    public static final String BRONZE = "bronze";
    public static final String STEEL = "steel";
    public static final String SILVER = "silver";
    public static final String ELECTRUM = "electrum";
    public static final String LEAD = "lead";
    public static final String NICKEL = "nickel";
    public static final String INVAR = "invar";
    public static final String CONSTANTAN = "constantan";
    public static final String PLATINUM = "platinum";
    public static final String ALUMINUM = "aluminum";
    public static final String SIGNALUM = "signalum";
    public static final String LUMIUM = "lumium";
    public static final String ENDERIUM = "enderium";
    public static final MapCodec<TypeDisabledCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("disabled").forGetter(condition -> condition.types)).apply((Applicative)instance, TypeDisabledCondition::new));
    private final List<String> types;

    public TypeDisabledCondition(List<String> types) {
        this.types = types;
    }

    public boolean test(ICondition.IContext context) {
        for (String type : this.types) {
            if (!disabledRecipeTypes.contains(type)) continue;
            return false;
        }
        return true;
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public static void clear() {
        disabledRecipeTypes.clear();
    }

    public static void updateType(String type, boolean disabled) {
        boolean containsValue = disabledRecipeTypes.contains(type);
        if (!containsValue && disabled) {
            disabledRecipeTypes.add(type);
        } else if (containsValue) {
            disabledRecipeTypes.remove(type);
        }
    }
}

