/*
 * Decompiled with CFR 0.152.
 */
package org.xiyu.spartanshieldsunofficial.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class ConditionalShapedRecipeBuilder {
    private final Item result;
    private final int count;
    private final ShapedRecipeBuilder builder;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionalShapedRecipeBuilder(ItemLike resultIn, int countIn) {
        this.result = resultIn.asItem();
        this.count = countIn;
        this.builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)resultIn, (int)countIn);
    }

    public static ConditionalShapedRecipeBuilder shaped(ItemLike itemIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, 1);
    }

    public static ConditionalShapedRecipeBuilder shaped(ItemLike itemIn, int countIn) {
        return new ConditionalShapedRecipeBuilder(itemIn, countIn);
    }

    public ConditionalShapedRecipeBuilder define(Character character, TagKey<Item> tagIn) {
        return this.define(character, Ingredient.of(tagIn));
    }

    public ConditionalShapedRecipeBuilder define(Character character, ItemLike itemIn) {
        return this.define(character, Ingredient.of((ItemLike[])new ItemLike[]{itemIn}));
    }

    public ConditionalShapedRecipeBuilder define(Character character, Ingredient ingredientIn) {
        this.builder.define(character, ingredientIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder pattern(String patternIn) {
        this.builder.pattern(patternIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder unlockedBy(String name, Criterion<?> criterionIn) {
        this.builder.unlockedBy(name, criterionIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder group(String groupIn) {
        this.builder.group(groupIn);
        return this;
    }

    public ConditionalShapedRecipeBuilder condition(ICondition conditionIn) {
        this.conditions.add(conditionIn);
        return this;
    }

    public void save(RecipeOutput output) {
        this.save(output, BuiltInRegistries.ITEM.getKey((Object)this.result));
    }

    public void save(RecipeOutput output, String save) {
        ResourceLocation resultLoc = BuiltInRegistries.ITEM.getKey((Object)this.result);
        ResourceLocation saveLoc = ResourceLocation.parse((String)save);
        if (saveLoc.equals((Object)resultLoc)) {
            throw new IllegalStateException("Shaped recipe " + save + " save argument is redundant as it's the same as the item id!");
        }
        this.save(output, saveLoc);
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        RecipeOutput conditionedOutput = output;
        if (!this.conditions.isEmpty()) {
            conditionedOutput = output.withConditions((ICondition[])this.conditions.toArray(ICondition[]::new));
        }
        this.builder.save(conditionedOutput, id);
    }
}

